/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLaunchConfigurationsResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeLaunchConfigurationsResponse.Builder, DescribeLaunchConfigurationsResponse> {
    private final List<LaunchConfiguration> launchConfigurations;

    private final String nextToken;

    private DescribeLaunchConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.launchConfigurations = builder.launchConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The launch configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The launch configurations.
     */
    public List<LaunchConfiguration> launchConfigurations() {
        return launchConfigurations;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLaunchConfigurationsResponse)) {
            return false;
        }
        DescribeLaunchConfigurationsResponse other = (DescribeLaunchConfigurationsResponse) obj;
        return Objects.equals(launchConfigurations(), other.launchConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeLaunchConfigurationsResponse").add("LaunchConfigurations", launchConfigurations())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchConfigurations":
            return Optional.ofNullable(clazz.cast(launchConfigurations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingResponse.Builder, CopyableBuilder<Builder, DescribeLaunchConfigurationsResponse> {
        /**
         * <p>
         * The launch configurations.
         * </p>
         * 
         * @param launchConfigurations
         *        The launch configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurations(Collection<LaunchConfiguration> launchConfigurations);

        /**
         * <p>
         * The launch configurations.
         * </p>
         * 
         * @param launchConfigurations
         *        The launch configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchConfigurations(LaunchConfiguration... launchConfigurations);

        /**
         * <p>
         * The launch configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LaunchConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<LaunchConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LaunchConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #launchConfigurations(List<LaunchConfiguration>)}.
         * 
         * @param launchConfigurations
         *        a consumer that will call methods on {@link List<LaunchConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #launchConfigurations(List<LaunchConfiguration>)
         */
        Builder launchConfigurations(Consumer<LaunchConfiguration.Builder>... launchConfigurations);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<LaunchConfiguration> launchConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLaunchConfigurationsResponse model) {
            super(model);
            launchConfigurations(model.launchConfigurations);
            nextToken(model.nextToken);
        }

        public final Collection<LaunchConfiguration.Builder> getLaunchConfigurations() {
            return launchConfigurations != null ? launchConfigurations.stream().map(LaunchConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder launchConfigurations(Collection<LaunchConfiguration> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationsCopier.copy(launchConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(LaunchConfiguration... launchConfigurations) {
            launchConfigurations(Arrays.asList(launchConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchConfigurations(Consumer<LaunchConfiguration.Builder>... launchConfigurations) {
            launchConfigurations(Stream.of(launchConfigurations).map(c -> LaunchConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLaunchConfigurations(Collection<LaunchConfiguration.BuilderImpl> launchConfigurations) {
            this.launchConfigurations = LaunchConfigurationsCopier.copyFromBuilder(launchConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLaunchConfigurationsResponse build() {
            return new DescribeLaunchConfigurationsResponse(this);
        }
    }
}
