/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLoadBalancerTargetGroupsResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeLoadBalancerTargetGroupsResponse.Builder, DescribeLoadBalancerTargetGroupsResponse> {
    private final List<LoadBalancerTargetGroupState> loadBalancerTargetGroups;

    private final String nextToken;

    private DescribeLoadBalancerTargetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.loadBalancerTargetGroups = builder.loadBalancerTargetGroups;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the target groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the target groups.
     */
    public List<LoadBalancerTargetGroupState> loadBalancerTargetGroups() {
        return loadBalancerTargetGroups;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadBalancerTargetGroups());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBalancerTargetGroupsResponse)) {
            return false;
        }
        DescribeLoadBalancerTargetGroupsResponse other = (DescribeLoadBalancerTargetGroupsResponse) obj;
        return Objects.equals(loadBalancerTargetGroups(), other.loadBalancerTargetGroups())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeLoadBalancerTargetGroupsResponse")
                .add("LoadBalancerTargetGroups", loadBalancerTargetGroups()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBalancerTargetGroups":
            return Optional.ofNullable(clazz.cast(loadBalancerTargetGroups()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingResponse.Builder,
            CopyableBuilder<Builder, DescribeLoadBalancerTargetGroupsResponse> {
        /**
         * <p>
         * Information about the target groups.
         * </p>
         * 
         * @param loadBalancerTargetGroups
         *        Information about the target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState> loadBalancerTargetGroups);

        /**
         * <p>
         * Information about the target groups.
         * </p>
         * 
         * @param loadBalancerTargetGroups
         *        Information about the target groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancerTargetGroups(LoadBalancerTargetGroupState... loadBalancerTargetGroups);

        /**
         * <p>
         * Information about the target groups.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadBalancerTargetGroupState>.Builder}
         * avoiding the need to create one manually via {@link List<LoadBalancerTargetGroupState>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadBalancerTargetGroupState>.Builder#build()} is called
         * immediately and its result is passed to {@link #loadBalancerTargetGroups(List<LoadBalancerTargetGroupState>)}
         * .
         * 
         * @param loadBalancerTargetGroups
         *        a consumer that will call methods on {@link List<LoadBalancerTargetGroupState>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancerTargetGroups(List<LoadBalancerTargetGroupState>)
         */
        Builder loadBalancerTargetGroups(Consumer<LoadBalancerTargetGroupState.Builder>... loadBalancerTargetGroups);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<LoadBalancerTargetGroupState> loadBalancerTargetGroups = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBalancerTargetGroupsResponse model) {
            super(model);
            loadBalancerTargetGroups(model.loadBalancerTargetGroups);
            nextToken(model.nextToken);
        }

        public final Collection<LoadBalancerTargetGroupState.Builder> getLoadBalancerTargetGroups() {
            return loadBalancerTargetGroups != null ? loadBalancerTargetGroups.stream()
                    .map(LoadBalancerTargetGroupState::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBalancerTargetGroups(Collection<LoadBalancerTargetGroupState> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = LoadBalancerTargetGroupStatesCopier.copy(loadBalancerTargetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerTargetGroups(LoadBalancerTargetGroupState... loadBalancerTargetGroups) {
            loadBalancerTargetGroups(Arrays.asList(loadBalancerTargetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancerTargetGroups(Consumer<LoadBalancerTargetGroupState.Builder>... loadBalancerTargetGroups) {
            loadBalancerTargetGroups(Stream.of(loadBalancerTargetGroups)
                    .map(c -> LoadBalancerTargetGroupState.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBalancerTargetGroups(
                Collection<LoadBalancerTargetGroupState.BuilderImpl> loadBalancerTargetGroups) {
            this.loadBalancerTargetGroups = LoadBalancerTargetGroupStatesCopier.copyFromBuilder(loadBalancerTargetGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeLoadBalancerTargetGroupsResponse build() {
            return new DescribeLoadBalancerTargetGroupsResponse(this);
        }
    }
}
