/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutePolicyRequest extends AutoScalingRequest implements
        ToCopyableBuilder<ExecutePolicyRequest.Builder, ExecutePolicyRequest> {
    private final String autoScalingGroupName;

    private final String policyName;

    private final Boolean honorCooldown;

    private final Double metricValue;

    private final Double breachThreshold;

    private ExecutePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.policyName = builder.policyName;
        this.honorCooldown = builder.honorCooldown;
        this.metricValue = builder.metricValue;
        this.breachThreshold = builder.breachThreshold;
    }

    /**
     * <p>
     * The name or Amazon Resource Name (ARN) of the Auto Scaling group.
     * </p>
     * 
     * @return The name or Amazon Resource Name (ARN) of the Auto Scaling group.
     */
    public String autoScalingGroupName() {
        return autoScalingGroupName;
    }

    /**
     * <p>
     * The name or ARN of the policy.
     * </p>
     * 
     * @return The name or ARN of the policy.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * If this parameter is true, Auto Scaling waits for the cooldown period to complete before executing the policy.
     * Otherwise, Auto Scaling executes the policy without waiting for the cooldown period to complete.
     * </p>
     * <p>
     * This parameter is not supported if the policy type is <code>StepScaling</code>.
     * </p>
     * <p>
     * For more information, see <a href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto
     * Scaling Cooldowns</a> in the <i>Auto Scaling User Guide</i>.
     * </p>
     * 
     * @return If this parameter is true, Auto Scaling waits for the cooldown period to complete before executing the
     *         policy. Otherwise, Auto Scaling executes the policy without waiting for the cooldown period to
     *         complete.</p>
     *         <p>
     *         This parameter is not supported if the policy type is <code>StepScaling</code>.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a>
     *         in the <i>Auto Scaling User Guide</i>.
     */
    public Boolean honorCooldown() {
        return honorCooldown;
    }

    /**
     * <p>
     * The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type
     * <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold is 50
     * and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the metric
     * value to 59.
     * </p>
     * <p>
     * If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call returns an
     * error.
     * </p>
     * <p>
     * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
     * </p>
     * 
     * @return The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type
     *         <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold
     *         is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set
     *         the metric value to 59.</p>
     *         <p>
     *         If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call
     *         returns an error.
     *         </p>
     *         <p>
     *         This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
     */
    public Double metricValue() {
        return metricValue;
    }

    /**
     * <p>
     * The breach threshold for the alarm.
     * </p>
     * <p>
     * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
     * </p>
     * 
     * @return The breach threshold for the alarm.</p>
     *         <p>
     *         This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
     */
    public Double breachThreshold() {
        return breachThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(honorCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(metricValue());
        hashCode = 31 * hashCode + Objects.hashCode(breachThreshold());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutePolicyRequest)) {
            return false;
        }
        ExecutePolicyRequest other = (ExecutePolicyRequest) obj;
        return Objects.equals(autoScalingGroupName(), other.autoScalingGroupName())
                && Objects.equals(policyName(), other.policyName()) && Objects.equals(honorCooldown(), other.honorCooldown())
                && Objects.equals(metricValue(), other.metricValue())
                && Objects.equals(breachThreshold(), other.breachThreshold());
    }

    @Override
    public String toString() {
        return ToString.builder("ExecutePolicyRequest").add("AutoScalingGroupName", autoScalingGroupName())
                .add("PolicyName", policyName()).add("HonorCooldown", honorCooldown()).add("MetricValue", metricValue())
                .add("BreachThreshold", breachThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutoScalingGroupName":
            return Optional.ofNullable(clazz.cast(autoScalingGroupName()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "HonorCooldown":
            return Optional.ofNullable(clazz.cast(honorCooldown()));
        case "MetricValue":
            return Optional.ofNullable(clazz.cast(metricValue()));
        case "BreachThreshold":
            return Optional.ofNullable(clazz.cast(breachThreshold()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, ExecutePolicyRequest> {
        /**
         * <p>
         * The name or Amazon Resource Name (ARN) of the Auto Scaling group.
         * </p>
         * 
         * @param autoScalingGroupName
         *        The name or Amazon Resource Name (ARN) of the Auto Scaling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingGroupName(String autoScalingGroupName);

        /**
         * <p>
         * The name or ARN of the policy.
         * </p>
         * 
         * @param policyName
         *        The name or ARN of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * If this parameter is true, Auto Scaling waits for the cooldown period to complete before executing the
         * policy. Otherwise, Auto Scaling executes the policy without waiting for the cooldown period to complete.
         * </p>
         * <p>
         * This parameter is not supported if the policy type is <code>StepScaling</code>.
         * </p>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling Cooldowns</a> in
         * the <i>Auto Scaling User Guide</i>.
         * </p>
         * 
         * @param honorCooldown
         *        If this parameter is true, Auto Scaling waits for the cooldown period to complete before executing the
         *        policy. Otherwise, Auto Scaling executes the policy without waiting for the cooldown period to
         *        complete.</p>
         *        <p>
         *        This parameter is not supported if the policy type is <code>StepScaling</code>.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/autoscaling/latest/userguide/Cooldown.html">Auto Scaling
         *        Cooldowns</a> in the <i>Auto Scaling User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder honorCooldown(Boolean honorCooldown);

        /**
         * <p>
         * The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of type
         * <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach threshold is
         * 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of 10, you can set the
         * metric value to 59.
         * </p>
         * <p>
         * If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call returns
         * an error.
         * </p>
         * <p>
         * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * </p>
         * 
         * @param metricValue
         *        The metric value to compare to <code>BreachThreshold</code>. This enables you to execute a policy of
         *        type <code>StepScaling</code> and determine which step adjustment to use. For example, if the breach
         *        threshold is 50 and you want to use a step adjustment with a lower bound of 0 and an upper bound of
         *        10, you can set the metric value to 59.</p>
         *        <p>
         *        If you specify a metric value that doesn't correspond to a step adjustment for the policy, the call
         *        returns an error.
         *        </p>
         *        <p>
         *        This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricValue(Double metricValue);

        /**
         * <p>
         * The breach threshold for the alarm.
         * </p>
         * <p>
         * This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * </p>
         * 
         * @param breachThreshold
         *        The breach threshold for the alarm.</p>
         *        <p>
         *        This parameter is required if the policy type is <code>StepScaling</code> and not supported otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder breachThreshold(Double breachThreshold);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private String autoScalingGroupName;

        private String policyName;

        private Boolean honorCooldown;

        private Double metricValue;

        private Double breachThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutePolicyRequest model) {
            super(model);
            autoScalingGroupName(model.autoScalingGroupName);
            policyName(model.policyName);
            honorCooldown(model.honorCooldown);
            metricValue(model.metricValue);
            breachThreshold(model.breachThreshold);
        }

        public final String getAutoScalingGroupName() {
            return autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final Boolean getHonorCooldown() {
            return honorCooldown;
        }

        @Override
        public final Builder honorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
            return this;
        }

        public final void setHonorCooldown(Boolean honorCooldown) {
            this.honorCooldown = honorCooldown;
        }

        public final Double getMetricValue() {
            return metricValue;
        }

        @Override
        public final Builder metricValue(Double metricValue) {
            this.metricValue = metricValue;
            return this;
        }

        public final void setMetricValue(Double metricValue) {
            this.metricValue = metricValue;
        }

        public final Double getBreachThreshold() {
            return breachThreshold;
        }

        @Override
        public final Builder breachThreshold(Double breachThreshold) {
            this.breachThreshold = breachThreshold;
            return this;
        }

        public final void setBreachThreshold(Double breachThreshold) {
            this.breachThreshold = breachThreshold;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecutePolicyRequest build() {
            return new ExecutePolicyRequest(this);
        }
    }
}
