/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * CreateLaunchConfigurationRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateLaunchConfigurationRequestMarshaller implements
        Marshaller<Request<CreateLaunchConfigurationRequest>, CreateLaunchConfigurationRequest> {

    public Request<CreateLaunchConfigurationRequest> marshall(CreateLaunchConfigurationRequest createLaunchConfigurationRequest) {

        if (createLaunchConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<CreateLaunchConfigurationRequest> request = new DefaultRequest<CreateLaunchConfigurationRequest>(
                createLaunchConfigurationRequest, "AutoScalingClient");
        request.addParameter("Action", "CreateLaunchConfiguration");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (createLaunchConfigurationRequest.launchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName",
                    StringConversion.fromString(createLaunchConfigurationRequest.launchConfigurationName()));
        }

        if (createLaunchConfigurationRequest.imageId() != null) {
            request.addParameter("ImageId", StringConversion.fromString(createLaunchConfigurationRequest.imageId()));
        }

        if (createLaunchConfigurationRequest.keyName() != null) {
            request.addParameter("KeyName", StringConversion.fromString(createLaunchConfigurationRequest.keyName()));
        }

        if (createLaunchConfigurationRequest.securityGroups().isEmpty()
                && !(createLaunchConfigurationRequest.securityGroups() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("SecurityGroups", "");
        } else if (!createLaunchConfigurationRequest.securityGroups().isEmpty()
                && !(createLaunchConfigurationRequest.securityGroups() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> securityGroupsList = createLaunchConfigurationRequest.securityGroups();
            int securityGroupsListIndex = 1;

            for (String securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("SecurityGroups.member." + securityGroupsListIndex,
                            StringConversion.fromString(securityGroupsListValue));
                }
                securityGroupsListIndex++;
            }
        }

        if (createLaunchConfigurationRequest.classicLinkVPCId() != null) {
            request.addParameter("ClassicLinkVPCId",
                    StringConversion.fromString(createLaunchConfigurationRequest.classicLinkVPCId()));
        }

        if (createLaunchConfigurationRequest.classicLinkVPCSecurityGroups().isEmpty()
                && !(createLaunchConfigurationRequest.classicLinkVPCSecurityGroups() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("ClassicLinkVPCSecurityGroups", "");
        } else if (!createLaunchConfigurationRequest.classicLinkVPCSecurityGroups().isEmpty()
                && !(createLaunchConfigurationRequest.classicLinkVPCSecurityGroups() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> classicLinkVPCSecurityGroupsList = createLaunchConfigurationRequest
                    .classicLinkVPCSecurityGroups();
            int classicLinkVPCSecurityGroupsListIndex = 1;

            for (String classicLinkVPCSecurityGroupsListValue : classicLinkVPCSecurityGroupsList) {
                if (classicLinkVPCSecurityGroupsListValue != null) {
                    request.addParameter("ClassicLinkVPCSecurityGroups.member." + classicLinkVPCSecurityGroupsListIndex,
                            StringConversion.fromString(classicLinkVPCSecurityGroupsListValue));
                }
                classicLinkVPCSecurityGroupsListIndex++;
            }
        }

        if (createLaunchConfigurationRequest.userData() != null) {
            request.addParameter("UserData", StringConversion.fromString(createLaunchConfigurationRequest.userData()));
        }

        if (createLaunchConfigurationRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString(createLaunchConfigurationRequest.instanceId()));
        }

        if (createLaunchConfigurationRequest.instanceType() != null) {
            request.addParameter("InstanceType", StringConversion.fromString(createLaunchConfigurationRequest.instanceType()));
        }

        if (createLaunchConfigurationRequest.kernelId() != null) {
            request.addParameter("KernelId", StringConversion.fromString(createLaunchConfigurationRequest.kernelId()));
        }

        if (createLaunchConfigurationRequest.ramdiskId() != null) {
            request.addParameter("RamdiskId", StringConversion.fromString(createLaunchConfigurationRequest.ramdiskId()));
        }

        if (createLaunchConfigurationRequest.blockDeviceMappings().isEmpty()
                && !(createLaunchConfigurationRequest.blockDeviceMappings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("BlockDeviceMappings", "");
        } else if (!createLaunchConfigurationRequest.blockDeviceMappings().isEmpty()
                && !(createLaunchConfigurationRequest.blockDeviceMappings() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<BlockDeviceMapping> blockDeviceMappingsList = createLaunchConfigurationRequest.blockDeviceMappings();
            int blockDeviceMappingsListIndex = 1;

            for (BlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {

                if (blockDeviceMappingsListValue.virtualName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".VirtualName",
                            StringConversion.fromString(blockDeviceMappingsListValue.virtualName()));
                }

                if (blockDeviceMappingsListValue.deviceName() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".DeviceName",
                            StringConversion.fromString(blockDeviceMappingsListValue.deviceName()));
                }

                Ebs ebs = blockDeviceMappingsListValue.ebs();
                if (ebs != null) {

                    if (ebs.snapshotId() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId",
                                StringConversion.fromString(ebs.snapshotId()));
                    }

                    if (ebs.volumeSize() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize",
                                StringConversion.fromInteger(ebs.volumeSize()));
                    }

                    if (ebs.volumeType() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.VolumeType",
                                StringConversion.fromString(ebs.volumeType()));
                    }

                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex
                                + ".Ebs.DeleteOnTermination", StringConversion.fromBoolean(ebs.deleteOnTermination()));
                    }

                    if (ebs.iops() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.Iops",
                                StringConversion.fromInteger(ebs.iops()));
                    }

                    if (ebs.encrypted() != null) {
                        request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".Ebs.Encrypted",
                                StringConversion.fromBoolean(ebs.encrypted()));
                    }
                }

                if (blockDeviceMappingsListValue.noDevice() != null) {
                    request.addParameter("BlockDeviceMappings.member." + blockDeviceMappingsListIndex + ".NoDevice",
                            StringConversion.fromBoolean(blockDeviceMappingsListValue.noDevice()));
                }
                blockDeviceMappingsListIndex++;
            }
        }

        InstanceMonitoring instanceMonitoring = createLaunchConfigurationRequest.instanceMonitoring();
        if (instanceMonitoring != null) {

            if (instanceMonitoring.enabled() != null) {
                request.addParameter("InstanceMonitoring.Enabled", StringConversion.fromBoolean(instanceMonitoring.enabled()));
            }
        }

        if (createLaunchConfigurationRequest.spotPrice() != null) {
            request.addParameter("SpotPrice", StringConversion.fromString(createLaunchConfigurationRequest.spotPrice()));
        }

        if (createLaunchConfigurationRequest.iamInstanceProfile() != null) {
            request.addParameter("IamInstanceProfile",
                    StringConversion.fromString(createLaunchConfigurationRequest.iamInstanceProfile()));
        }

        if (createLaunchConfigurationRequest.ebsOptimized() != null) {
            request.addParameter("EbsOptimized", StringConversion.fromBoolean(createLaunchConfigurationRequest.ebsOptimized()));
        }

        if (createLaunchConfigurationRequest.associatePublicIpAddress() != null) {
            request.addParameter("AssociatePublicIpAddress",
                    StringConversion.fromBoolean(createLaunchConfigurationRequest.associatePublicIpAddress()));
        }

        if (createLaunchConfigurationRequest.placementTenancy() != null) {
            request.addParameter("PlacementTenancy",
                    StringConversion.fromString(createLaunchConfigurationRequest.placementTenancy()));
        }

        return request;
    }

}
