/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers.*;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;

/**
 * CreateLaunchConfigurationResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CreateLaunchConfigurationResponseUnmarshaller implements
        Unmarshaller<CreateLaunchConfigurationResponse, StaxUnmarshallerContext> {

    public CreateLaunchConfigurationResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        CreateLaunchConfigurationResponse.Builder createLaunchConfigurationResponse = CreateLaunchConfigurationResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        return createLaunchConfigurationResponse.build();
    }

    private static final CreateLaunchConfigurationResponseUnmarshaller INSTANCE = new CreateLaunchConfigurationResponseUnmarshaller();

    public static CreateLaunchConfigurationResponseUnmarshaller getInstance() {
        return INSTANCE;
    }
}
