/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * DescribeTagsRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeTagsRequestMarshaller implements Marshaller<Request<DescribeTagsRequest>, DescribeTagsRequest> {

    public Request<DescribeTagsRequest> marshall(DescribeTagsRequest describeTagsRequest) {

        if (describeTagsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<DescribeTagsRequest> request = new DefaultRequest<DescribeTagsRequest>(describeTagsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeTags");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (describeTagsRequest.filters().isEmpty()
                && !(describeTagsRequest.filters() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Filters", "");
        } else if (!describeTagsRequest.filters().isEmpty()
                && !(describeTagsRequest.filters() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<Filter> filtersList = describeTagsRequest.filters();
            int filtersListIndex = 1;

            for (Filter filtersListValue : filtersList) {

                if (filtersListValue.name() != null) {
                    request.addParameter("Filters.member." + filtersListIndex + ".Name",
                            StringConversion.fromString(filtersListValue.name()));
                }

                if (filtersListValue.values().isEmpty()
                        && !(filtersListValue.values() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    request.addParameter("Filters.member." + filtersListIndex + ".Values", "");
                } else if (!filtersListValue.values().isEmpty()
                        && !(filtersListValue.values() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
                    java.util.List<String> valuesList = filtersListValue.values();
                    int valuesListIndex = 1;

                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filters.member." + filtersListIndex + ".Values.member." + valuesListIndex,
                                    StringConversion.fromString(valuesListValue));
                        }
                        valuesListIndex++;
                    }
                }
                filtersListIndex++;
            }
        }

        if (describeTagsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString(describeTagsRequest.nextToken()));
        }

        if (describeTagsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger(describeTagsRequest.maxRecords()));
        }

        return request;
    }

}
