/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * EnableMetricsCollectionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class EnableMetricsCollectionRequestMarshaller implements
        Marshaller<Request<EnableMetricsCollectionRequest>, EnableMetricsCollectionRequest> {

    public Request<EnableMetricsCollectionRequest> marshall(EnableMetricsCollectionRequest enableMetricsCollectionRequest) {

        if (enableMetricsCollectionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<EnableMetricsCollectionRequest> request = new DefaultRequest<EnableMetricsCollectionRequest>(
                enableMetricsCollectionRequest, "AutoScalingClient");
        request.addParameter("Action", "EnableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (enableMetricsCollectionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringConversion.fromString(enableMetricsCollectionRequest.autoScalingGroupName()));
        }

        if (enableMetricsCollectionRequest.metrics().isEmpty()
                && !(enableMetricsCollectionRequest.metrics() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("Metrics", "");
        } else if (!enableMetricsCollectionRequest.metrics().isEmpty()
                && !(enableMetricsCollectionRequest.metrics() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> metricsList = enableMetricsCollectionRequest.metrics();
            int metricsListIndex = 1;

            for (String metricsListValue : metricsList) {
                if (metricsListValue != null) {
                    request.addParameter("Metrics.member." + metricsListIndex, StringConversion.fromString(metricsListValue));
                }
                metricsListIndex++;
            }
        }

        if (enableMetricsCollectionRequest.granularity() != null) {
            request.addParameter("Granularity", StringConversion.fromString(enableMetricsCollectionRequest.granularity()));
        }

        return request;
    }

}
