/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * UpdateAutoScalingGroupRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class UpdateAutoScalingGroupRequestMarshaller implements
        Marshaller<Request<UpdateAutoScalingGroupRequest>, UpdateAutoScalingGroupRequest> {

    public Request<UpdateAutoScalingGroupRequest> marshall(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) {

        if (updateAutoScalingGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<UpdateAutoScalingGroupRequest> request = new DefaultRequest<UpdateAutoScalingGroupRequest>(
                updateAutoScalingGroupRequest, "AutoScalingClient");
        request.addParameter("Action", "UpdateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (updateAutoScalingGroupRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringConversion.fromString(updateAutoScalingGroupRequest.autoScalingGroupName()));
        }

        if (updateAutoScalingGroupRequest.launchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName",
                    StringConversion.fromString(updateAutoScalingGroupRequest.launchConfigurationName()));
        }

        if (updateAutoScalingGroupRequest.minSize() != null) {
            request.addParameter("MinSize", StringConversion.fromInteger(updateAutoScalingGroupRequest.minSize()));
        }

        if (updateAutoScalingGroupRequest.maxSize() != null) {
            request.addParameter("MaxSize", StringConversion.fromInteger(updateAutoScalingGroupRequest.maxSize()));
        }

        if (updateAutoScalingGroupRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringConversion.fromInteger(updateAutoScalingGroupRequest.desiredCapacity()));
        }

        if (updateAutoScalingGroupRequest.defaultCooldown() != null) {
            request.addParameter("DefaultCooldown", StringConversion.fromInteger(updateAutoScalingGroupRequest.defaultCooldown()));
        }

        if (updateAutoScalingGroupRequest.availabilityZones().isEmpty()
                && !(updateAutoScalingGroupRequest.availabilityZones() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("AvailabilityZones", "");
        } else if (!updateAutoScalingGroupRequest.availabilityZones().isEmpty()
                && !(updateAutoScalingGroupRequest.availabilityZones() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> availabilityZonesList = updateAutoScalingGroupRequest.availabilityZones();
            int availabilityZonesListIndex = 1;

            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex,
                            StringConversion.fromString(availabilityZonesListValue));
                }
                availabilityZonesListIndex++;
            }
        }

        if (updateAutoScalingGroupRequest.healthCheckType() != null) {
            request.addParameter("HealthCheckType", StringConversion.fromString(updateAutoScalingGroupRequest.healthCheckType()));
        }

        if (updateAutoScalingGroupRequest.healthCheckGracePeriod() != null) {
            request.addParameter("HealthCheckGracePeriod",
                    StringConversion.fromInteger(updateAutoScalingGroupRequest.healthCheckGracePeriod()));
        }

        if (updateAutoScalingGroupRequest.placementGroup() != null) {
            request.addParameter("PlacementGroup", StringConversion.fromString(updateAutoScalingGroupRequest.placementGroup()));
        }

        if (updateAutoScalingGroupRequest.vpcZoneIdentifier() != null) {
            request.addParameter("VPCZoneIdentifier",
                    StringConversion.fromString(updateAutoScalingGroupRequest.vpcZoneIdentifier()));
        }

        if (updateAutoScalingGroupRequest.terminationPolicies().isEmpty()
                && !(updateAutoScalingGroupRequest.terminationPolicies() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("TerminationPolicies", "");
        } else if (!updateAutoScalingGroupRequest.terminationPolicies().isEmpty()
                && !(updateAutoScalingGroupRequest.terminationPolicies() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> terminationPoliciesList = updateAutoScalingGroupRequest.terminationPolicies();
            int terminationPoliciesListIndex = 1;

            for (String terminationPoliciesListValue : terminationPoliciesList) {
                if (terminationPoliciesListValue != null) {
                    request.addParameter("TerminationPolicies.member." + terminationPoliciesListIndex,
                            StringConversion.fromString(terminationPoliciesListValue));
                }
                terminationPoliciesListIndex++;
            }
        }

        if (updateAutoScalingGroupRequest.newInstancesProtectedFromScaleIn() != null) {
            request.addParameter("NewInstancesProtectedFromScaleIn",
                    StringConversion.fromBoolean(updateAutoScalingGroupRequest.newInstancesProtectedFromScaleIn()));
        }

        return request;
    }

}
