/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Alarm
implements ToCopyableBuilder<Builder, Alarm> {
    private final String alarmName;
    private final String alarmARN;

    private Alarm(BuilderImpl builder) {
        this.alarmName = builder.alarmName;
        this.alarmARN = builder.alarmARN;
    }

    public String alarmName() {
        return this.alarmName;
    }

    public String alarmARN() {
        return this.alarmARN;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmARN());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Alarm)) {
            return false;
        }
        Alarm other = (Alarm)obj;
        return Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.alarmARN(), other.alarmARN());
    }

    public String toString() {
        return ToString.builder((String)"Alarm").add("AlarmName", (Object)this.alarmName()).add("AlarmARN", (Object)this.alarmARN()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmName": {
                return Optional.ofNullable(clazz.cast(this.alarmName()));
            }
            case "AlarmARN": {
                return Optional.ofNullable(clazz.cast(this.alarmARN()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String alarmName;
        private String alarmARN;

        private BuilderImpl() {
        }

        private BuilderImpl(Alarm model) {
            this.alarmName(model.alarmName);
            this.alarmARN(model.alarmARN);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getAlarmARN() {
            return this.alarmARN;
        }

        @Override
        public final Builder alarmARN(String alarmARN) {
            this.alarmARN = alarmARN;
            return this;
        }

        public final void setAlarmARN(String alarmARN) {
            this.alarmARN = alarmARN;
        }

        public Alarm build() {
            return new Alarm(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Alarm> {
        public Builder alarmName(String var1);

        public Builder alarmARN(String var1);
    }
}

