/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.LifecycleHookNamesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLifecycleHooksRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeLifecycleHooksRequest> {
    private final String autoScalingGroupName;
    private final List<String> lifecycleHookNames;

    private DescribeLifecycleHooksRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleHookNames = builder.lifecycleHookNames;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<String> lifecycleHookNames() {
        return this.lifecycleHookNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleHookNames());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLifecycleHooksRequest)) {
            return false;
        }
        DescribeLifecycleHooksRequest other = (DescribeLifecycleHooksRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.lifecycleHookNames(), other.lifecycleHookNames());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLifecycleHooksRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("LifecycleHookNames", this.lifecycleHookNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "LifecycleHookNames": {
                return Optional.ofNullable(clazz.cast(this.lifecycleHookNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> lifecycleHookNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLifecycleHooksRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.lifecycleHookNames(model.lifecycleHookNames);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getLifecycleHookNames() {
            return this.lifecycleHookNames;
        }

        @Override
        public final Builder lifecycleHookNames(Collection<String> lifecycleHookNames) {
            this.lifecycleHookNames = LifecycleHookNamesCopier.copy(lifecycleHookNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifecycleHookNames(String ... lifecycleHookNames) {
            this.lifecycleHookNames(Arrays.asList(lifecycleHookNames));
            return this;
        }

        public final void setLifecycleHookNames(Collection<String> lifecycleHookNames) {
            this.lifecycleHookNames = LifecycleHookNamesCopier.copy(lifecycleHookNames);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLifecycleHooksRequest build() {
            return new DescribeLifecycleHooksRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, DescribeLifecycleHooksRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder lifecycleHookNames(Collection<String> var1);

        public Builder lifecycleHookNames(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

