/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroupNamesCopier;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeNotificationConfigurationsRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DescribeNotificationConfigurationsRequest> {
    private final List<String> autoScalingGroupNames;
    private final String nextToken;
    private final Integer maxRecords;

    private DescribeNotificationConfigurationsRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupNames = builder.autoScalingGroupNames;
        this.nextToken = builder.nextToken;
        this.maxRecords = builder.maxRecords;
    }

    public List<String> autoScalingGroupNames() {
        return this.autoScalingGroupNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationConfigurationsRequest)) {
            return false;
        }
        DescribeNotificationConfigurationsRequest other = (DescribeNotificationConfigurationsRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupNames(), other.autoScalingGroupNames()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxRecords(), other.maxRecords());
    }

    public String toString() {
        return ToString.builder((String)"DescribeNotificationConfigurationsRequest").add("AutoScalingGroupNames", this.autoScalingGroupNames()).add("NextToken", (Object)this.nextToken()).add("MaxRecords", (Object)this.maxRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupNames": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxRecords": {
                return Optional.ofNullable(clazz.cast(this.maxRecords()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private List<String> autoScalingGroupNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationConfigurationsRequest model) {
            super(model);
            this.autoScalingGroupNames(model.autoScalingGroupNames);
            this.nextToken(model.nextToken);
            this.maxRecords(model.maxRecords);
        }

        public final Collection<String> getAutoScalingGroupNames() {
            return this.autoScalingGroupNames;
        }

        @Override
        public final Builder autoScalingGroupNames(Collection<String> autoScalingGroupNames) {
            this.autoScalingGroupNames = AutoScalingGroupNamesCopier.copy(autoScalingGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroupNames(String ... autoScalingGroupNames) {
            this.autoScalingGroupNames(Arrays.asList(autoScalingGroupNames));
            return this;
        }

        public final void setAutoScalingGroupNames(Collection<String> autoScalingGroupNames) {
            this.autoScalingGroupNames = AutoScalingGroupNamesCopier.copy(autoScalingGroupNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeNotificationConfigurationsRequest build() {
            return new DescribeNotificationConfigurationsRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, DescribeNotificationConfigurationsRequest> {
        public Builder autoScalingGroupNames(Collection<String> var1);

        public Builder autoScalingGroupNames(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxRecords(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

