/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.services.autoscaling.model.TargetGroupARNsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DetachLoadBalancerTargetGroupsRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, DetachLoadBalancerTargetGroupsRequest> {
    private final String autoScalingGroupName;
    private final List<String> targetGroupARNs;

    private DetachLoadBalancerTargetGroupsRequest(BuilderImpl builder) {
        super(builder);
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.targetGroupARNs = builder.targetGroupARNs;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public List<String> targetGroupARNs() {
        return this.targetGroupARNs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetGroupARNs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachLoadBalancerTargetGroupsRequest)) {
            return false;
        }
        DetachLoadBalancerTargetGroupsRequest other = (DetachLoadBalancerTargetGroupsRequest)((Object)obj);
        return Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.targetGroupARNs(), other.targetGroupARNs());
    }

    public String toString() {
        return ToString.builder((String)"DetachLoadBalancerTargetGroupsRequest").add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("TargetGroupARNs", this.targetGroupARNs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "TargetGroupARNs": {
                return Optional.ofNullable(clazz.cast(this.targetGroupARNs()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String autoScalingGroupName;
        private List<String> targetGroupARNs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DetachLoadBalancerTargetGroupsRequest model) {
            super(model);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.targetGroupARNs(model.targetGroupARNs);
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final Collection<String> getTargetGroupARNs() {
            return this.targetGroupARNs;
        }

        @Override
        public final Builder targetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupARNs(String ... targetGroupARNs) {
            this.targetGroupARNs(Arrays.asList(targetGroupARNs));
            return this;
        }

        public final void setTargetGroupARNs(Collection<String> targetGroupARNs) {
            this.targetGroupARNs = TargetGroupARNsCopier.copy(targetGroupARNs);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetachLoadBalancerTargetGroupsRequest build() {
            return new DetachLoadBalancerTargetGroupsRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, DetachLoadBalancerTargetGroupsRequest> {
        public Builder autoScalingGroupName(String var1);

        public Builder targetGroupARNs(Collection<String> var1);

        public Builder targetGroupARNs(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

