/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutLifecycleHookRequest
extends AutoScalingRequest
implements ToCopyableBuilder<Builder, PutLifecycleHookRequest> {
    private final String lifecycleHookName;
    private final String autoScalingGroupName;
    private final String lifecycleTransition;
    private final String roleARN;
    private final String notificationTargetARN;
    private final String notificationMetadata;
    private final Integer heartbeatTimeout;
    private final String defaultResult;

    private PutLifecycleHookRequest(BuilderImpl builder) {
        super(builder);
        this.lifecycleHookName = builder.lifecycleHookName;
        this.autoScalingGroupName = builder.autoScalingGroupName;
        this.lifecycleTransition = builder.lifecycleTransition;
        this.roleARN = builder.roleARN;
        this.notificationTargetARN = builder.notificationTargetARN;
        this.notificationMetadata = builder.notificationMetadata;
        this.heartbeatTimeout = builder.heartbeatTimeout;
        this.defaultResult = builder.defaultResult;
    }

    public String lifecycleHookName() {
        return this.lifecycleHookName;
    }

    public String autoScalingGroupName() {
        return this.autoScalingGroupName;
    }

    public String lifecycleTransition() {
        return this.lifecycleTransition;
    }

    public String roleARN() {
        return this.roleARN;
    }

    public String notificationTargetARN() {
        return this.notificationTargetARN;
    }

    public String notificationMetadata() {
        return this.notificationMetadata;
    }

    public Integer heartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public String defaultResult() {
        return this.defaultResult;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleHookName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleTransition());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationTargetARN());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.heartbeatTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultResult());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutLifecycleHookRequest)) {
            return false;
        }
        PutLifecycleHookRequest other = (PutLifecycleHookRequest)((Object)obj);
        return Objects.equals(this.lifecycleHookName(), other.lifecycleHookName()) && Objects.equals(this.autoScalingGroupName(), other.autoScalingGroupName()) && Objects.equals(this.lifecycleTransition(), other.lifecycleTransition()) && Objects.equals(this.roleARN(), other.roleARN()) && Objects.equals(this.notificationTargetARN(), other.notificationTargetARN()) && Objects.equals(this.notificationMetadata(), other.notificationMetadata()) && Objects.equals(this.heartbeatTimeout(), other.heartbeatTimeout()) && Objects.equals(this.defaultResult(), other.defaultResult());
    }

    public String toString() {
        return ToString.builder((String)"PutLifecycleHookRequest").add("LifecycleHookName", (Object)this.lifecycleHookName()).add("AutoScalingGroupName", (Object)this.autoScalingGroupName()).add("LifecycleTransition", (Object)this.lifecycleTransition()).add("RoleARN", (Object)this.roleARN()).add("NotificationTargetARN", (Object)this.notificationTargetARN()).add("NotificationMetadata", (Object)this.notificationMetadata()).add("HeartbeatTimeout", (Object)this.heartbeatTimeout()).add("DefaultResult", (Object)this.defaultResult()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecycleHookName": {
                return Optional.ofNullable(clazz.cast(this.lifecycleHookName()));
            }
            case "AutoScalingGroupName": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroupName()));
            }
            case "LifecycleTransition": {
                return Optional.ofNullable(clazz.cast(this.lifecycleTransition()));
            }
            case "RoleARN": {
                return Optional.ofNullable(clazz.cast(this.roleARN()));
            }
            case "NotificationTargetARN": {
                return Optional.ofNullable(clazz.cast(this.notificationTargetARN()));
            }
            case "NotificationMetadata": {
                return Optional.ofNullable(clazz.cast(this.notificationMetadata()));
            }
            case "HeartbeatTimeout": {
                return Optional.ofNullable(clazz.cast(this.heartbeatTimeout()));
            }
            case "DefaultResult": {
                return Optional.ofNullable(clazz.cast(this.defaultResult()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AutoScalingRequest.BuilderImpl
    implements Builder {
        private String lifecycleHookName;
        private String autoScalingGroupName;
        private String lifecycleTransition;
        private String roleARN;
        private String notificationTargetARN;
        private String notificationMetadata;
        private Integer heartbeatTimeout;
        private String defaultResult;

        private BuilderImpl() {
        }

        private BuilderImpl(PutLifecycleHookRequest model) {
            super(model);
            this.lifecycleHookName(model.lifecycleHookName);
            this.autoScalingGroupName(model.autoScalingGroupName);
            this.lifecycleTransition(model.lifecycleTransition);
            this.roleARN(model.roleARN);
            this.notificationTargetARN(model.notificationTargetARN);
            this.notificationMetadata(model.notificationMetadata);
            this.heartbeatTimeout(model.heartbeatTimeout);
            this.defaultResult(model.defaultResult);
        }

        public final String getLifecycleHookName() {
            return this.lifecycleHookName;
        }

        @Override
        public final Builder lifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        public final void setLifecycleHookName(String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
        }

        public final String getAutoScalingGroupName() {
            return this.autoScalingGroupName;
        }

        @Override
        public final Builder autoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
            return this;
        }

        public final void setAutoScalingGroupName(String autoScalingGroupName) {
            this.autoScalingGroupName = autoScalingGroupName;
        }

        public final String getLifecycleTransition() {
            return this.lifecycleTransition;
        }

        @Override
        public final Builder lifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
            return this;
        }

        public final void setLifecycleTransition(String lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
        }

        public final String getRoleARN() {
            return this.roleARN;
        }

        @Override
        public final Builder roleARN(String roleARN) {
            this.roleARN = roleARN;
            return this;
        }

        public final void setRoleARN(String roleARN) {
            this.roleARN = roleARN;
        }

        public final String getNotificationTargetARN() {
            return this.notificationTargetARN;
        }

        @Override
        public final Builder notificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
            return this;
        }

        public final void setNotificationTargetARN(String notificationTargetARN) {
            this.notificationTargetARN = notificationTargetARN;
        }

        public final String getNotificationMetadata() {
            return this.notificationMetadata;
        }

        @Override
        public final Builder notificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
            return this;
        }

        public final void setNotificationMetadata(String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
        }

        public final Integer getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final Builder heartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        public final void setHeartbeatTimeout(Integer heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
        }

        public final String getDefaultResult() {
            return this.defaultResult;
        }

        @Override
        public final Builder defaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        public final void setDefaultResult(String defaultResult) {
            this.defaultResult = defaultResult;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutLifecycleHookRequest build() {
            return new PutLifecycleHookRequest(this);
        }
    }

    public static interface Builder
    extends AutoScalingRequest.Builder,
    CopyableBuilder<Builder, PutLifecycleHookRequest> {
        public Builder lifecycleHookName(String var1);

        public Builder autoScalingGroupName(String var1);

        public Builder lifecycleTransition(String var1);

        public Builder roleARN(String var1);

        public Builder notificationTargetARN(String var1);

        public Builder notificationMetadata(String var1);

        public Builder heartbeatTimeout(Integer var1);

        public Builder defaultResult(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

