/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuspendedProcess
implements ToCopyableBuilder<Builder, SuspendedProcess> {
    private final String processName;
    private final String suspensionReason;

    private SuspendedProcess(BuilderImpl builder) {
        this.processName = builder.processName;
        this.suspensionReason = builder.suspensionReason;
    }

    public String processName() {
        return this.processName;
    }

    public String suspensionReason() {
        return this.suspensionReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.processName());
        hashCode = 31 * hashCode + Objects.hashCode(this.suspensionReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuspendedProcess)) {
            return false;
        }
        SuspendedProcess other = (SuspendedProcess)obj;
        return Objects.equals(this.processName(), other.processName()) && Objects.equals(this.suspensionReason(), other.suspensionReason());
    }

    public String toString() {
        return ToString.builder((String)"SuspendedProcess").add("ProcessName", (Object)this.processName()).add("SuspensionReason", (Object)this.suspensionReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProcessName": {
                return Optional.ofNullable(clazz.cast(this.processName()));
            }
            case "SuspensionReason": {
                return Optional.ofNullable(clazz.cast(this.suspensionReason()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String processName;
        private String suspensionReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SuspendedProcess model) {
            this.processName(model.processName);
            this.suspensionReason(model.suspensionReason);
        }

        public final String getProcessName() {
            return this.processName;
        }

        @Override
        public final Builder processName(String processName) {
            this.processName = processName;
            return this;
        }

        public final void setProcessName(String processName) {
            this.processName = processName;
        }

        public final String getSuspensionReason() {
            return this.suspensionReason;
        }

        @Override
        public final Builder suspensionReason(String suspensionReason) {
            this.suspensionReason = suspensionReason;
            return this;
        }

        public final void setSuspensionReason(String suspensionReason) {
            this.suspensionReason = suspensionReason;
        }

        public SuspendedProcess build() {
            return new SuspendedProcess(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SuspendedProcess> {
        public Builder processName(String var1);

        public Builder suspensionReason(String var1);
    }
}

