/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroup;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;

public class DescribeAutoScalingGroupsIterable
implements SdkIterable<DescribeAutoScalingGroupsResponse> {
    private final AutoScalingClient client;
    private final DescribeAutoScalingGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAutoScalingGroupsIterable(AutoScalingClient client, DescribeAutoScalingGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAutoScalingGroupsResponseFetcher();
    }

    public Iterator<DescribeAutoScalingGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutoScalingGroup> autoScalingGroups() {
        Function<DescribeAutoScalingGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.autoScalingGroups() != null) {
                return response.autoScalingGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeAutoScalingGroupsIterable resume(DescribeAutoScalingGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeAutoScalingGroupsIterable(this.client, (DescribeAutoScalingGroupsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeAutoScalingGroupsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeAutoScalingGroupsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeAutoScalingGroupsResponseFetcher
    implements SyncPageFetcher<DescribeAutoScalingGroupsResponse> {
        private DescribeAutoScalingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAutoScalingGroupsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public DescribeAutoScalingGroupsResponse nextPage(DescribeAutoScalingGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAutoScalingGroupsIterable.this.client.describeAutoScalingGroups(DescribeAutoScalingGroupsIterable.this.firstRequest);
            }
            return DescribeAutoScalingGroupsIterable.this.client.describeAutoScalingGroups((DescribeAutoScalingGroupsRequest)((Object)DescribeAutoScalingGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

