/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingGroup;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsResponse;

public class DescribeAutoScalingGroupsPublisher
implements SdkPublisher<DescribeAutoScalingGroupsResponse> {
    private final AutoScalingAsyncClient client;
    private final DescribeAutoScalingGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAutoScalingGroupsPublisher(AutoScalingAsyncClient client, DescribeAutoScalingGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAutoScalingGroupsPublisher(AutoScalingAsyncClient client, DescribeAutoScalingGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAutoScalingGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAutoScalingGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutoScalingGroup> autoScalingGroups() {
        Function<DescribeAutoScalingGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.autoScalingGroups() != null) {
                return response.autoScalingGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAutoScalingGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeAutoScalingGroupsPublisher resume(DescribeAutoScalingGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeAutoScalingGroupsPublisher(this.client, (DescribeAutoScalingGroupsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeAutoScalingGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeAutoScalingGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeAutoScalingGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeAutoScalingGroupsResponse> {
        private DescribeAutoScalingGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAutoScalingGroupsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<DescribeAutoScalingGroupsResponse> nextPage(DescribeAutoScalingGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAutoScalingGroupsPublisher.this.client.describeAutoScalingGroups(DescribeAutoScalingGroupsPublisher.this.firstRequest);
            }
            return DescribeAutoScalingGroupsPublisher.this.client.describeAutoScalingGroups((DescribeAutoScalingGroupsRequest)((Object)DescribeAutoScalingGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

