/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.autoscaling.AutoScalingClient;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingInstanceDetails;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse;

public class DescribeAutoScalingInstancesIterable
implements SdkIterable<DescribeAutoScalingInstancesResponse> {
    private final AutoScalingClient client;
    private final DescribeAutoScalingInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeAutoScalingInstancesIterable(AutoScalingClient client, DescribeAutoScalingInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAutoScalingInstancesResponseFetcher();
    }

    public Iterator<DescribeAutoScalingInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AutoScalingInstanceDetails> autoScalingInstances() {
        Function<DescribeAutoScalingInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.autoScalingInstances() != null) {
                return response.autoScalingInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeAutoScalingInstancesIterable resume(DescribeAutoScalingInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeAutoScalingInstancesIterable(this.client, (DescribeAutoScalingInstancesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeAutoScalingInstancesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeAutoScalingInstancesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeAutoScalingInstancesResponseFetcher
    implements SyncPageFetcher<DescribeAutoScalingInstancesResponse> {
        private DescribeAutoScalingInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAutoScalingInstancesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public DescribeAutoScalingInstancesResponse nextPage(DescribeAutoScalingInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAutoScalingInstancesIterable.this.client.describeAutoScalingInstances(DescribeAutoScalingInstancesIterable.this.firstRequest);
            }
            return DescribeAutoScalingInstancesIterable.this.client.describeAutoScalingInstances((DescribeAutoScalingInstancesRequest)((Object)DescribeAutoScalingInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

