/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.model.AutoScalingInstanceDetails;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingInstancesResponse;

public class DescribeAutoScalingInstancesPublisher
implements SdkPublisher<DescribeAutoScalingInstancesResponse> {
    private final AutoScalingAsyncClient client;
    private final DescribeAutoScalingInstancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAutoScalingInstancesPublisher(AutoScalingAsyncClient client, DescribeAutoScalingInstancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAutoScalingInstancesPublisher(AutoScalingAsyncClient client, DescribeAutoScalingInstancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAutoScalingInstancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAutoScalingInstancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutoScalingInstanceDetails> autoScalingInstances() {
        Function<DescribeAutoScalingInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.autoScalingInstances() != null) {
                return response.autoScalingInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAutoScalingInstancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeAutoScalingInstancesPublisher resume(DescribeAutoScalingInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeAutoScalingInstancesPublisher(this.client, (DescribeAutoScalingInstancesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeAutoScalingInstancesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeAutoScalingInstancesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeAutoScalingInstancesResponseFetcher
    implements AsyncPageFetcher<DescribeAutoScalingInstancesResponse> {
        private DescribeAutoScalingInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAutoScalingInstancesResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<DescribeAutoScalingInstancesResponse> nextPage(DescribeAutoScalingInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeAutoScalingInstancesPublisher.this.client.describeAutoScalingInstances(DescribeAutoScalingInstancesPublisher.this.firstRequest);
            }
            return DescribeAutoScalingInstancesPublisher.this.client.describeAutoScalingInstances((DescribeAutoScalingInstancesRequest)((Object)DescribeAutoScalingInstancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

