/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.autoscaling.AutoScalingAsyncClient;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsRequest;
import software.amazon.awssdk.services.autoscaling.model.DescribeLaunchConfigurationsResponse;
import software.amazon.awssdk.services.autoscaling.model.LaunchConfiguration;

public class DescribeLaunchConfigurationsPublisher
implements SdkPublisher<DescribeLaunchConfigurationsResponse> {
    private final AutoScalingAsyncClient client;
    private final DescribeLaunchConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLaunchConfigurationsPublisher(AutoScalingAsyncClient client, DescribeLaunchConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLaunchConfigurationsPublisher(AutoScalingAsyncClient client, DescribeLaunchConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLaunchConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLaunchConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LaunchConfiguration> launchConfigurations() {
        Function<DescribeLaunchConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.launchConfigurations() != null) {
                return response.launchConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeLaunchConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeLaunchConfigurationsPublisher resume(DescribeLaunchConfigurationsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeLaunchConfigurationsPublisher(this.client, (DescribeLaunchConfigurationsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeLaunchConfigurationsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeLaunchConfigurationsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeLaunchConfigurationsResponseFetcher
    implements AsyncPageFetcher<DescribeLaunchConfigurationsResponse> {
        private DescribeLaunchConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLaunchConfigurationsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<DescribeLaunchConfigurationsResponse> nextPage(DescribeLaunchConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLaunchConfigurationsPublisher.this.client.describeLaunchConfigurations(DescribeLaunchConfigurationsPublisher.this.firstRequest);
            }
            return DescribeLaunchConfigurationsPublisher.this.client.describeLaunchConfigurations((DescribeLaunchConfigurationsRequest)((Object)DescribeLaunchConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

