/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.AttachInstancesRequest;

public class AttachInstancesRequestMarshaller
implements Marshaller<Request<AttachInstancesRequest>, AttachInstancesRequest> {
    public Request<AttachInstancesRequest> marshall(AttachInstancesRequest attachInstancesRequest) {
        if (attachInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)attachInstancesRequest, "AutoScalingClient");
        request.addParameter("Action", "AttachInstances");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachInstancesRequest.instanceIds().isEmpty() && !(attachInstancesRequest.instanceIds() instanceof SdkAutoConstructList)) {
            request.addParameter("InstanceIds", "");
        } else if (!attachInstancesRequest.instanceIds().isEmpty() && !(attachInstancesRequest.instanceIds() instanceof SdkAutoConstructList)) {
            List<String> instanceIdsList = attachInstancesRequest.instanceIds();
            int instanceIdsListIndex = 1;
            for (String instanceIdsListValue : instanceIdsList) {
                if (instanceIdsListValue != null) {
                    request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringConversion.fromString((String)instanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (attachInstancesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)attachInstancesRequest.autoScalingGroupName()));
        }
        return request;
    }
}

