/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.AttachLoadBalancerTargetGroupsRequest;

public class AttachLoadBalancerTargetGroupsRequestMarshaller
implements Marshaller<Request<AttachLoadBalancerTargetGroupsRequest>, AttachLoadBalancerTargetGroupsRequest> {
    public Request<AttachLoadBalancerTargetGroupsRequest> marshall(AttachLoadBalancerTargetGroupsRequest attachLoadBalancerTargetGroupsRequest) {
        if (attachLoadBalancerTargetGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)attachLoadBalancerTargetGroupsRequest, "AutoScalingClient");
        request.addParameter("Action", "AttachLoadBalancerTargetGroups");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachLoadBalancerTargetGroupsRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)attachLoadBalancerTargetGroupsRequest.autoScalingGroupName()));
        }
        if (attachLoadBalancerTargetGroupsRequest.targetGroupARNs().isEmpty() && !(attachLoadBalancerTargetGroupsRequest.targetGroupARNs() instanceof SdkAutoConstructList)) {
            request.addParameter("TargetGroupARNs", "");
        } else if (!attachLoadBalancerTargetGroupsRequest.targetGroupARNs().isEmpty() && !(attachLoadBalancerTargetGroupsRequest.targetGroupARNs() instanceof SdkAutoConstructList)) {
            List<String> targetGroupARNsList = attachLoadBalancerTargetGroupsRequest.targetGroupARNs();
            int targetGroupARNsListIndex = 1;
            for (String targetGroupARNsListValue : targetGroupARNsList) {
                if (targetGroupARNsListValue != null) {
                    request.addParameter("TargetGroupARNs.member." + targetGroupARNsListIndex, StringConversion.fromString((String)targetGroupARNsListValue));
                }
                ++targetGroupARNsListIndex;
            }
        }
        return request;
    }
}

