/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.CompleteLifecycleActionRequest;

public class CompleteLifecycleActionRequestMarshaller
implements Marshaller<Request<CompleteLifecycleActionRequest>, CompleteLifecycleActionRequest> {
    public Request<CompleteLifecycleActionRequest> marshall(CompleteLifecycleActionRequest completeLifecycleActionRequest) {
        if (completeLifecycleActionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)completeLifecycleActionRequest, "AutoScalingClient");
        request.addParameter("Action", "CompleteLifecycleAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (completeLifecycleActionRequest.lifecycleHookName() != null) {
            request.addParameter("LifecycleHookName", StringConversion.fromString((String)completeLifecycleActionRequest.lifecycleHookName()));
        }
        if (completeLifecycleActionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)completeLifecycleActionRequest.autoScalingGroupName()));
        }
        if (completeLifecycleActionRequest.lifecycleActionToken() != null) {
            request.addParameter("LifecycleActionToken", StringConversion.fromString((String)completeLifecycleActionRequest.lifecycleActionToken()));
        }
        if (completeLifecycleActionRequest.lifecycleActionResult() != null) {
            request.addParameter("LifecycleActionResult", StringConversion.fromString((String)completeLifecycleActionRequest.lifecycleActionResult()));
        }
        if (completeLifecycleActionRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)completeLifecycleActionRequest.instanceId()));
        }
        return request;
    }
}

