/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.CreateAutoScalingGroupRequest;
import software.amazon.awssdk.services.autoscaling.model.LifecycleHookSpecification;
import software.amazon.awssdk.services.autoscaling.model.Tag;

public class CreateAutoScalingGroupRequestMarshaller
implements Marshaller<Request<CreateAutoScalingGroupRequest>, CreateAutoScalingGroupRequest> {
    public Request<CreateAutoScalingGroupRequest> marshall(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) {
        if (createAutoScalingGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createAutoScalingGroupRequest, "AutoScalingClient");
        request.addParameter("Action", "CreateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createAutoScalingGroupRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)createAutoScalingGroupRequest.autoScalingGroupName()));
        }
        if (createAutoScalingGroupRequest.launchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringConversion.fromString((String)createAutoScalingGroupRequest.launchConfigurationName()));
        }
        if (createAutoScalingGroupRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringConversion.fromString((String)createAutoScalingGroupRequest.instanceId()));
        }
        if (createAutoScalingGroupRequest.minSize() != null) {
            request.addParameter("MinSize", StringConversion.fromInteger((Integer)createAutoScalingGroupRequest.minSize()));
        }
        if (createAutoScalingGroupRequest.maxSize() != null) {
            request.addParameter("MaxSize", StringConversion.fromInteger((Integer)createAutoScalingGroupRequest.maxSize()));
        }
        if (createAutoScalingGroupRequest.desiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringConversion.fromInteger((Integer)createAutoScalingGroupRequest.desiredCapacity()));
        }
        if (createAutoScalingGroupRequest.defaultCooldown() != null) {
            request.addParameter("DefaultCooldown", StringConversion.fromInteger((Integer)createAutoScalingGroupRequest.defaultCooldown()));
        }
        if (createAutoScalingGroupRequest.availabilityZones().isEmpty() && !(createAutoScalingGroupRequest.availabilityZones() instanceof SdkAutoConstructList)) {
            request.addParameter("AvailabilityZones", "");
        } else if (!createAutoScalingGroupRequest.availabilityZones().isEmpty() && !(createAutoScalingGroupRequest.availabilityZones() instanceof SdkAutoConstructList)) {
            List<String> availabilityZonesList = createAutoScalingGroupRequest.availabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringConversion.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (createAutoScalingGroupRequest.loadBalancerNames().isEmpty() && !(createAutoScalingGroupRequest.loadBalancerNames() instanceof SdkAutoConstructList)) {
            request.addParameter("LoadBalancerNames", "");
        } else if (!createAutoScalingGroupRequest.loadBalancerNames().isEmpty() && !(createAutoScalingGroupRequest.loadBalancerNames() instanceof SdkAutoConstructList)) {
            List<String> loadBalancerNamesList = createAutoScalingGroupRequest.loadBalancerNames();
            int loadBalancerNamesListIndex = 1;
            for (String loadBalancerNamesListValue : loadBalancerNamesList) {
                if (loadBalancerNamesListValue != null) {
                    request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringConversion.fromString((String)loadBalancerNamesListValue));
                }
                ++loadBalancerNamesListIndex;
            }
        }
        if (createAutoScalingGroupRequest.targetGroupARNs().isEmpty() && !(createAutoScalingGroupRequest.targetGroupARNs() instanceof SdkAutoConstructList)) {
            request.addParameter("TargetGroupARNs", "");
        } else if (!createAutoScalingGroupRequest.targetGroupARNs().isEmpty() && !(createAutoScalingGroupRequest.targetGroupARNs() instanceof SdkAutoConstructList)) {
            List<String> targetGroupARNsList = createAutoScalingGroupRequest.targetGroupARNs();
            int targetGroupARNsListIndex = 1;
            for (String targetGroupARNsListValue : targetGroupARNsList) {
                if (targetGroupARNsListValue != null) {
                    request.addParameter("TargetGroupARNs.member." + targetGroupARNsListIndex, StringConversion.fromString((String)targetGroupARNsListValue));
                }
                ++targetGroupARNsListIndex;
            }
        }
        if (createAutoScalingGroupRequest.healthCheckType() != null) {
            request.addParameter("HealthCheckType", StringConversion.fromString((String)createAutoScalingGroupRequest.healthCheckType()));
        }
        if (createAutoScalingGroupRequest.healthCheckGracePeriod() != null) {
            request.addParameter("HealthCheckGracePeriod", StringConversion.fromInteger((Integer)createAutoScalingGroupRequest.healthCheckGracePeriod()));
        }
        if (createAutoScalingGroupRequest.placementGroup() != null) {
            request.addParameter("PlacementGroup", StringConversion.fromString((String)createAutoScalingGroupRequest.placementGroup()));
        }
        if (createAutoScalingGroupRequest.vpcZoneIdentifier() != null) {
            request.addParameter("VPCZoneIdentifier", StringConversion.fromString((String)createAutoScalingGroupRequest.vpcZoneIdentifier()));
        }
        if (createAutoScalingGroupRequest.terminationPolicies().isEmpty() && !(createAutoScalingGroupRequest.terminationPolicies() instanceof SdkAutoConstructList)) {
            request.addParameter("TerminationPolicies", "");
        } else if (!createAutoScalingGroupRequest.terminationPolicies().isEmpty() && !(createAutoScalingGroupRequest.terminationPolicies() instanceof SdkAutoConstructList)) {
            List<String> terminationPoliciesList = createAutoScalingGroupRequest.terminationPolicies();
            int terminationPoliciesListIndex = 1;
            for (String terminationPoliciesListValue : terminationPoliciesList) {
                if (terminationPoliciesListValue != null) {
                    request.addParameter("TerminationPolicies.member." + terminationPoliciesListIndex, StringConversion.fromString((String)terminationPoliciesListValue));
                }
                ++terminationPoliciesListIndex;
            }
        }
        if (createAutoScalingGroupRequest.newInstancesProtectedFromScaleIn() != null) {
            request.addParameter("NewInstancesProtectedFromScaleIn", StringConversion.fromBoolean((Boolean)createAutoScalingGroupRequest.newInstancesProtectedFromScaleIn()));
        }
        if (createAutoScalingGroupRequest.lifecycleHookSpecificationList().isEmpty() && !(createAutoScalingGroupRequest.lifecycleHookSpecificationList() instanceof SdkAutoConstructList)) {
            request.addParameter("LifecycleHookSpecificationList", "");
        } else if (!createAutoScalingGroupRequest.lifecycleHookSpecificationList().isEmpty() && !(createAutoScalingGroupRequest.lifecycleHookSpecificationList() instanceof SdkAutoConstructList)) {
            List<LifecycleHookSpecification> lifecycleHookSpecificationListList = createAutoScalingGroupRequest.lifecycleHookSpecificationList();
            int lifecycleHookSpecificationListListIndex = 1;
            for (LifecycleHookSpecification lifecycleHookSpecificationListListValue : lifecycleHookSpecificationListList) {
                if (lifecycleHookSpecificationListListValue.lifecycleHookName() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".LifecycleHookName", StringConversion.fromString((String)lifecycleHookSpecificationListListValue.lifecycleHookName()));
                }
                if (lifecycleHookSpecificationListListValue.lifecycleTransition() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".LifecycleTransition", StringConversion.fromString((String)lifecycleHookSpecificationListListValue.lifecycleTransition()));
                }
                if (lifecycleHookSpecificationListListValue.notificationMetadata() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".NotificationMetadata", StringConversion.fromString((String)lifecycleHookSpecificationListListValue.notificationMetadata()));
                }
                if (lifecycleHookSpecificationListListValue.heartbeatTimeout() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".HeartbeatTimeout", StringConversion.fromInteger((Integer)lifecycleHookSpecificationListListValue.heartbeatTimeout()));
                }
                if (lifecycleHookSpecificationListListValue.defaultResult() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".DefaultResult", StringConversion.fromString((String)lifecycleHookSpecificationListListValue.defaultResult()));
                }
                if (lifecycleHookSpecificationListListValue.notificationTargetARN() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".NotificationTargetARN", StringConversion.fromString((String)lifecycleHookSpecificationListListValue.notificationTargetARN()));
                }
                if (lifecycleHookSpecificationListListValue.roleARN() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".RoleARN", StringConversion.fromString((String)lifecycleHookSpecificationListListValue.roleARN()));
                }
                ++lifecycleHookSpecificationListListIndex;
            }
        }
        if (createAutoScalingGroupRequest.tags().isEmpty() && !(createAutoScalingGroupRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createAutoScalingGroupRequest.tags().isEmpty() && !(createAutoScalingGroupRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createAutoScalingGroupRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.resourceId() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceId", StringConversion.fromString((String)tagsListValue.resourceId()));
                }
                if (tagsListValue.resourceType() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceType", StringConversion.fromString((String)tagsListValue.resourceType()));
                }
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                if (tagsListValue.propagateAtLaunch() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".PropagateAtLaunch", StringConversion.fromBoolean((Boolean)tagsListValue.propagateAtLaunch()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

