/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.CreateOrUpdateTagsRequest;
import software.amazon.awssdk.services.autoscaling.model.Tag;

public class CreateOrUpdateTagsRequestMarshaller
implements Marshaller<Request<CreateOrUpdateTagsRequest>, CreateOrUpdateTagsRequest> {
    public Request<CreateOrUpdateTagsRequest> marshall(CreateOrUpdateTagsRequest createOrUpdateTagsRequest) {
        if (createOrUpdateTagsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)createOrUpdateTagsRequest, "AutoScalingClient");
        request.addParameter("Action", "CreateOrUpdateTags");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createOrUpdateTagsRequest.tags().isEmpty() && !(createOrUpdateTagsRequest.tags() instanceof SdkAutoConstructList)) {
            request.addParameter("Tags", "");
        } else if (!createOrUpdateTagsRequest.tags().isEmpty() && !(createOrUpdateTagsRequest.tags() instanceof SdkAutoConstructList)) {
            List<Tag> tagsList = createOrUpdateTagsRequest.tags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.resourceId() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceId", StringConversion.fromString((String)tagsListValue.resourceId()));
                }
                if (tagsListValue.resourceType() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceType", StringConversion.fromString((String)tagsListValue.resourceType()));
                }
                if (tagsListValue.key() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringConversion.fromString((String)tagsListValue.key()));
                }
                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringConversion.fromString((String)tagsListValue.value()));
                }
                if (tagsListValue.propagateAtLaunch() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".PropagateAtLaunch", StringConversion.fromBoolean((Boolean)tagsListValue.propagateAtLaunch()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

