/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DeleteAutoScalingGroupRequest;

public class DeleteAutoScalingGroupRequestMarshaller
implements Marshaller<Request<DeleteAutoScalingGroupRequest>, DeleteAutoScalingGroupRequest> {
    public Request<DeleteAutoScalingGroupRequest> marshall(DeleteAutoScalingGroupRequest deleteAutoScalingGroupRequest) {
        if (deleteAutoScalingGroupRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteAutoScalingGroupRequest, "AutoScalingClient");
        request.addParameter("Action", "DeleteAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteAutoScalingGroupRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)deleteAutoScalingGroupRequest.autoScalingGroupName()));
        }
        if (deleteAutoScalingGroupRequest.forceDelete() != null) {
            request.addParameter("ForceDelete", StringConversion.fromBoolean((Boolean)deleteAutoScalingGroupRequest.forceDelete()));
        }
        return request;
    }
}

