/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DescribeAutoScalingGroupsRequest;

public class DescribeAutoScalingGroupsRequestMarshaller
implements Marshaller<Request<DescribeAutoScalingGroupsRequest>, DescribeAutoScalingGroupsRequest> {
    public Request<DescribeAutoScalingGroupsRequest> marshall(DescribeAutoScalingGroupsRequest describeAutoScalingGroupsRequest) {
        if (describeAutoScalingGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeAutoScalingGroupsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeAutoScalingGroups");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAutoScalingGroupsRequest.autoScalingGroupNames().isEmpty() && !(describeAutoScalingGroupsRequest.autoScalingGroupNames() instanceof SdkAutoConstructList)) {
            request.addParameter("AutoScalingGroupNames", "");
        } else if (!describeAutoScalingGroupsRequest.autoScalingGroupNames().isEmpty() && !(describeAutoScalingGroupsRequest.autoScalingGroupNames() instanceof SdkAutoConstructList)) {
            List<String> autoScalingGroupNamesList = describeAutoScalingGroupsRequest.autoScalingGroupNames();
            int autoScalingGroupNamesListIndex = 1;
            for (String autoScalingGroupNamesListValue : autoScalingGroupNamesList) {
                if (autoScalingGroupNamesListValue != null) {
                    request.addParameter("AutoScalingGroupNames.member." + autoScalingGroupNamesListIndex, StringConversion.fromString((String)autoScalingGroupNamesListValue));
                }
                ++autoScalingGroupNamesListIndex;
            }
        }
        if (describeAutoScalingGroupsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeAutoScalingGroupsRequest.nextToken()));
        }
        if (describeAutoScalingGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeAutoScalingGroupsRequest.maxRecords()));
        }
        return request;
    }
}

