/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DescribeLoadBalancerTargetGroupsRequest;

public class DescribeLoadBalancerTargetGroupsRequestMarshaller
implements Marshaller<Request<DescribeLoadBalancerTargetGroupsRequest>, DescribeLoadBalancerTargetGroupsRequest> {
    public Request<DescribeLoadBalancerTargetGroupsRequest> marshall(DescribeLoadBalancerTargetGroupsRequest describeLoadBalancerTargetGroupsRequest) {
        if (describeLoadBalancerTargetGroupsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeLoadBalancerTargetGroupsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeLoadBalancerTargetGroups");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeLoadBalancerTargetGroupsRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)describeLoadBalancerTargetGroupsRequest.autoScalingGroupName()));
        }
        if (describeLoadBalancerTargetGroupsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeLoadBalancerTargetGroupsRequest.nextToken()));
        }
        if (describeLoadBalancerTargetGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeLoadBalancerTargetGroupsRequest.maxRecords()));
        }
        return request;
    }
}

