/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DescribeNotificationConfigurationsRequest;

public class DescribeNotificationConfigurationsRequestMarshaller
implements Marshaller<Request<DescribeNotificationConfigurationsRequest>, DescribeNotificationConfigurationsRequest> {
    public Request<DescribeNotificationConfigurationsRequest> marshall(DescribeNotificationConfigurationsRequest describeNotificationConfigurationsRequest) {
        if (describeNotificationConfigurationsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeNotificationConfigurationsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeNotificationConfigurations");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeNotificationConfigurationsRequest.autoScalingGroupNames().isEmpty() && !(describeNotificationConfigurationsRequest.autoScalingGroupNames() instanceof SdkAutoConstructList)) {
            request.addParameter("AutoScalingGroupNames", "");
        } else if (!describeNotificationConfigurationsRequest.autoScalingGroupNames().isEmpty() && !(describeNotificationConfigurationsRequest.autoScalingGroupNames() instanceof SdkAutoConstructList)) {
            List<String> autoScalingGroupNamesList = describeNotificationConfigurationsRequest.autoScalingGroupNames();
            int autoScalingGroupNamesListIndex = 1;
            for (String autoScalingGroupNamesListValue : autoScalingGroupNamesList) {
                if (autoScalingGroupNamesListValue != null) {
                    request.addParameter("AutoScalingGroupNames.member." + autoScalingGroupNamesListIndex, StringConversion.fromString((String)autoScalingGroupNamesListValue));
                }
                ++autoScalingGroupNamesListIndex;
            }
        }
        if (describeNotificationConfigurationsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeNotificationConfigurationsRequest.nextToken()));
        }
        if (describeNotificationConfigurationsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeNotificationConfigurationsRequest.maxRecords()));
        }
        return request;
    }
}

