/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DescribeScalingActivitiesRequest;

public class DescribeScalingActivitiesRequestMarshaller
implements Marshaller<Request<DescribeScalingActivitiesRequest>, DescribeScalingActivitiesRequest> {
    public Request<DescribeScalingActivitiesRequest> marshall(DescribeScalingActivitiesRequest describeScalingActivitiesRequest) {
        if (describeScalingActivitiesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeScalingActivitiesRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeScalingActivities");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeScalingActivitiesRequest.activityIds().isEmpty() && !(describeScalingActivitiesRequest.activityIds() instanceof SdkAutoConstructList)) {
            request.addParameter("ActivityIds", "");
        } else if (!describeScalingActivitiesRequest.activityIds().isEmpty() && !(describeScalingActivitiesRequest.activityIds() instanceof SdkAutoConstructList)) {
            List<String> activityIdsList = describeScalingActivitiesRequest.activityIds();
            int activityIdsListIndex = 1;
            for (String activityIdsListValue : activityIdsList) {
                if (activityIdsListValue != null) {
                    request.addParameter("ActivityIds.member." + activityIdsListIndex, StringConversion.fromString((String)activityIdsListValue));
                }
                ++activityIdsListIndex;
            }
        }
        if (describeScalingActivitiesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)describeScalingActivitiesRequest.autoScalingGroupName()));
        }
        if (describeScalingActivitiesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeScalingActivitiesRequest.maxRecords()));
        }
        if (describeScalingActivitiesRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeScalingActivitiesRequest.nextToken()));
        }
        return request;
    }
}

