/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DescribeScheduledActionsRequest;

public class DescribeScheduledActionsRequestMarshaller
implements Marshaller<Request<DescribeScheduledActionsRequest>, DescribeScheduledActionsRequest> {
    public Request<DescribeScheduledActionsRequest> marshall(DescribeScheduledActionsRequest describeScheduledActionsRequest) {
        if (describeScheduledActionsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeScheduledActionsRequest, "AutoScalingClient");
        request.addParameter("Action", "DescribeScheduledActions");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeScheduledActionsRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)describeScheduledActionsRequest.autoScalingGroupName()));
        }
        if (describeScheduledActionsRequest.scheduledActionNames().isEmpty() && !(describeScheduledActionsRequest.scheduledActionNames() instanceof SdkAutoConstructList)) {
            request.addParameter("ScheduledActionNames", "");
        } else if (!describeScheduledActionsRequest.scheduledActionNames().isEmpty() && !(describeScheduledActionsRequest.scheduledActionNames() instanceof SdkAutoConstructList)) {
            List<String> scheduledActionNamesList = describeScheduledActionsRequest.scheduledActionNames();
            int scheduledActionNamesListIndex = 1;
            for (String scheduledActionNamesListValue : scheduledActionNamesList) {
                if (scheduledActionNamesListValue != null) {
                    request.addParameter("ScheduledActionNames.member." + scheduledActionNamesListIndex, StringConversion.fromString((String)scheduledActionNamesListValue));
                }
                ++scheduledActionNamesListIndex;
            }
        }
        if (describeScheduledActionsRequest.startTime() != null) {
            request.addParameter("StartTime", StringConversion.fromInstant((Instant)describeScheduledActionsRequest.startTime()));
        }
        if (describeScheduledActionsRequest.endTime() != null) {
            request.addParameter("EndTime", StringConversion.fromInstant((Instant)describeScheduledActionsRequest.endTime()));
        }
        if (describeScheduledActionsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringConversion.fromString((String)describeScheduledActionsRequest.nextToken()));
        }
        if (describeScheduledActionsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeScheduledActionsRequest.maxRecords()));
        }
        return request;
    }
}

