/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DetachInstancesRequest;

public class DetachInstancesRequestMarshaller
implements Marshaller<Request<DetachInstancesRequest>, DetachInstancesRequest> {
    public Request<DetachInstancesRequest> marshall(DetachInstancesRequest detachInstancesRequest) {
        if (detachInstancesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)detachInstancesRequest, "AutoScalingClient");
        request.addParameter("Action", "DetachInstances");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachInstancesRequest.instanceIds().isEmpty() && !(detachInstancesRequest.instanceIds() instanceof SdkAutoConstructList)) {
            request.addParameter("InstanceIds", "");
        } else if (!detachInstancesRequest.instanceIds().isEmpty() && !(detachInstancesRequest.instanceIds() instanceof SdkAutoConstructList)) {
            List<String> instanceIdsList = detachInstancesRequest.instanceIds();
            int instanceIdsListIndex = 1;
            for (String instanceIdsListValue : instanceIdsList) {
                if (instanceIdsListValue != null) {
                    request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringConversion.fromString((String)instanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (detachInstancesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)detachInstancesRequest.autoScalingGroupName()));
        }
        if (detachInstancesRequest.shouldDecrementDesiredCapacity() != null) {
            request.addParameter("ShouldDecrementDesiredCapacity", StringConversion.fromBoolean((Boolean)detachInstancesRequest.shouldDecrementDesiredCapacity()));
        }
        return request;
    }
}

