/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DetachLoadBalancersRequest;

public class DetachLoadBalancersRequestMarshaller
implements Marshaller<Request<DetachLoadBalancersRequest>, DetachLoadBalancersRequest> {
    public Request<DetachLoadBalancersRequest> marshall(DetachLoadBalancersRequest detachLoadBalancersRequest) {
        if (detachLoadBalancersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)detachLoadBalancersRequest, "AutoScalingClient");
        request.addParameter("Action", "DetachLoadBalancers");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (detachLoadBalancersRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)detachLoadBalancersRequest.autoScalingGroupName()));
        }
        if (detachLoadBalancersRequest.loadBalancerNames().isEmpty() && !(detachLoadBalancersRequest.loadBalancerNames() instanceof SdkAutoConstructList)) {
            request.addParameter("LoadBalancerNames", "");
        } else if (!detachLoadBalancersRequest.loadBalancerNames().isEmpty() && !(detachLoadBalancersRequest.loadBalancerNames() instanceof SdkAutoConstructList)) {
            List<String> loadBalancerNamesList = detachLoadBalancersRequest.loadBalancerNames();
            int loadBalancerNamesListIndex = 1;
            for (String loadBalancerNamesListValue : loadBalancerNamesList) {
                if (loadBalancerNamesListValue != null) {
                    request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringConversion.fromString((String)loadBalancerNamesListValue));
                }
                ++loadBalancerNamesListIndex;
            }
        }
        return request;
    }
}

