/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.DisableMetricsCollectionRequest;

public class DisableMetricsCollectionRequestMarshaller
implements Marshaller<Request<DisableMetricsCollectionRequest>, DisableMetricsCollectionRequest> {
    public Request<DisableMetricsCollectionRequest> marshall(DisableMetricsCollectionRequest disableMetricsCollectionRequest) {
        if (disableMetricsCollectionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)disableMetricsCollectionRequest, "AutoScalingClient");
        request.addParameter("Action", "DisableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (disableMetricsCollectionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)disableMetricsCollectionRequest.autoScalingGroupName()));
        }
        if (disableMetricsCollectionRequest.metrics().isEmpty() && !(disableMetricsCollectionRequest.metrics() instanceof SdkAutoConstructList)) {
            request.addParameter("Metrics", "");
        } else if (!disableMetricsCollectionRequest.metrics().isEmpty() && !(disableMetricsCollectionRequest.metrics() instanceof SdkAutoConstructList)) {
            List<String> metricsList = disableMetricsCollectionRequest.metrics();
            int metricsListIndex = 1;
            for (String metricsListValue : metricsList) {
                if (metricsListValue != null) {
                    request.addParameter("Metrics.member." + metricsListIndex, StringConversion.fromString((String)metricsListValue));
                }
                ++metricsListIndex;
            }
        }
        return request;
    }
}

