/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.EnableMetricsCollectionRequest;

public class EnableMetricsCollectionRequestMarshaller
implements Marshaller<Request<EnableMetricsCollectionRequest>, EnableMetricsCollectionRequest> {
    public Request<EnableMetricsCollectionRequest> marshall(EnableMetricsCollectionRequest enableMetricsCollectionRequest) {
        if (enableMetricsCollectionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)enableMetricsCollectionRequest, "AutoScalingClient");
        request.addParameter("Action", "EnableMetricsCollection");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (enableMetricsCollectionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)enableMetricsCollectionRequest.autoScalingGroupName()));
        }
        if (enableMetricsCollectionRequest.metrics().isEmpty() && !(enableMetricsCollectionRequest.metrics() instanceof SdkAutoConstructList)) {
            request.addParameter("Metrics", "");
        } else if (!enableMetricsCollectionRequest.metrics().isEmpty() && !(enableMetricsCollectionRequest.metrics() instanceof SdkAutoConstructList)) {
            List<String> metricsList = enableMetricsCollectionRequest.metrics();
            int metricsListIndex = 1;
            for (String metricsListValue : metricsList) {
                if (metricsListValue != null) {
                    request.addParameter("Metrics.member." + metricsListIndex, StringConversion.fromString((String)metricsListValue));
                }
                ++metricsListIndex;
            }
        }
        if (enableMetricsCollectionRequest.granularity() != null) {
            request.addParameter("Granularity", StringConversion.fromString((String)enableMetricsCollectionRequest.granularity()));
        }
        return request;
    }
}

