/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.EnterStandbyRequest;

public class EnterStandbyRequestMarshaller
implements Marshaller<Request<EnterStandbyRequest>, EnterStandbyRequest> {
    public Request<EnterStandbyRequest> marshall(EnterStandbyRequest enterStandbyRequest) {
        if (enterStandbyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)enterStandbyRequest, "AutoScalingClient");
        request.addParameter("Action", "EnterStandby");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (enterStandbyRequest.instanceIds().isEmpty() && !(enterStandbyRequest.instanceIds() instanceof SdkAutoConstructList)) {
            request.addParameter("InstanceIds", "");
        } else if (!enterStandbyRequest.instanceIds().isEmpty() && !(enterStandbyRequest.instanceIds() instanceof SdkAutoConstructList)) {
            List<String> instanceIdsList = enterStandbyRequest.instanceIds();
            int instanceIdsListIndex = 1;
            for (String instanceIdsListValue : instanceIdsList) {
                if (instanceIdsListValue != null) {
                    request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringConversion.fromString((String)instanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (enterStandbyRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)enterStandbyRequest.autoScalingGroupName()));
        }
        if (enterStandbyRequest.shouldDecrementDesiredCapacity() != null) {
            request.addParameter("ShouldDecrementDesiredCapacity", StringConversion.fromBoolean((Boolean)enterStandbyRequest.shouldDecrementDesiredCapacity()));
        }
        return request;
    }
}

