/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.ExecutePolicyRequest;

public class ExecutePolicyRequestMarshaller
implements Marshaller<Request<ExecutePolicyRequest>, ExecutePolicyRequest> {
    public Request<ExecutePolicyRequest> marshall(ExecutePolicyRequest executePolicyRequest) {
        if (executePolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)executePolicyRequest, "AutoScalingClient");
        request.addParameter("Action", "ExecutePolicy");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (executePolicyRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)executePolicyRequest.autoScalingGroupName()));
        }
        if (executePolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringConversion.fromString((String)executePolicyRequest.policyName()));
        }
        if (executePolicyRequest.honorCooldown() != null) {
            request.addParameter("HonorCooldown", StringConversion.fromBoolean((Boolean)executePolicyRequest.honorCooldown()));
        }
        if (executePolicyRequest.metricValue() != null) {
            request.addParameter("MetricValue", StringConversion.fromDouble((Double)executePolicyRequest.metricValue()));
        }
        if (executePolicyRequest.breachThreshold() != null) {
            request.addParameter("BreachThreshold", StringConversion.fromDouble((Double)executePolicyRequest.breachThreshold()));
        }
        return request;
    }
}

