/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.PutLifecycleHookRequest;

public class PutLifecycleHookRequestMarshaller
implements Marshaller<Request<PutLifecycleHookRequest>, PutLifecycleHookRequest> {
    public Request<PutLifecycleHookRequest> marshall(PutLifecycleHookRequest putLifecycleHookRequest) {
        if (putLifecycleHookRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putLifecycleHookRequest, "AutoScalingClient");
        request.addParameter("Action", "PutLifecycleHook");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putLifecycleHookRequest.lifecycleHookName() != null) {
            request.addParameter("LifecycleHookName", StringConversion.fromString((String)putLifecycleHookRequest.lifecycleHookName()));
        }
        if (putLifecycleHookRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)putLifecycleHookRequest.autoScalingGroupName()));
        }
        if (putLifecycleHookRequest.lifecycleTransition() != null) {
            request.addParameter("LifecycleTransition", StringConversion.fromString((String)putLifecycleHookRequest.lifecycleTransition()));
        }
        if (putLifecycleHookRequest.roleARN() != null) {
            request.addParameter("RoleARN", StringConversion.fromString((String)putLifecycleHookRequest.roleARN()));
        }
        if (putLifecycleHookRequest.notificationTargetARN() != null) {
            request.addParameter("NotificationTargetARN", StringConversion.fromString((String)putLifecycleHookRequest.notificationTargetARN()));
        }
        if (putLifecycleHookRequest.notificationMetadata() != null) {
            request.addParameter("NotificationMetadata", StringConversion.fromString((String)putLifecycleHookRequest.notificationMetadata()));
        }
        if (putLifecycleHookRequest.heartbeatTimeout() != null) {
            request.addParameter("HeartbeatTimeout", StringConversion.fromInteger((Integer)putLifecycleHookRequest.heartbeatTimeout()));
        }
        if (putLifecycleHookRequest.defaultResult() != null) {
            request.addParameter("DefaultResult", StringConversion.fromString((String)putLifecycleHookRequest.defaultResult()));
        }
        return request;
    }
}

