/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.PutNotificationConfigurationRequest;

public class PutNotificationConfigurationRequestMarshaller
implements Marshaller<Request<PutNotificationConfigurationRequest>, PutNotificationConfigurationRequest> {
    public Request<PutNotificationConfigurationRequest> marshall(PutNotificationConfigurationRequest putNotificationConfigurationRequest) {
        if (putNotificationConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putNotificationConfigurationRequest, "AutoScalingClient");
        request.addParameter("Action", "PutNotificationConfiguration");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putNotificationConfigurationRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)putNotificationConfigurationRequest.autoScalingGroupName()));
        }
        if (putNotificationConfigurationRequest.topicARN() != null) {
            request.addParameter("TopicARN", StringConversion.fromString((String)putNotificationConfigurationRequest.topicARN()));
        }
        if (putNotificationConfigurationRequest.notificationTypes().isEmpty() && !(putNotificationConfigurationRequest.notificationTypes() instanceof SdkAutoConstructList)) {
            request.addParameter("NotificationTypes", "");
        } else if (!putNotificationConfigurationRequest.notificationTypes().isEmpty() && !(putNotificationConfigurationRequest.notificationTypes() instanceof SdkAutoConstructList)) {
            List<String> notificationTypesList = putNotificationConfigurationRequest.notificationTypes();
            int notificationTypesListIndex = 1;
            for (String notificationTypesListValue : notificationTypesList) {
                if (notificationTypesListValue != null) {
                    request.addParameter("NotificationTypes.member." + notificationTypesListIndex, StringConversion.fromString((String)notificationTypesListValue));
                }
                ++notificationTypesListIndex;
            }
        }
        return request;
    }
}

