/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.CustomizedMetricSpecification;
import software.amazon.awssdk.services.autoscaling.model.MetricDimension;
import software.amazon.awssdk.services.autoscaling.model.PredefinedMetricSpecification;
import software.amazon.awssdk.services.autoscaling.model.PutScalingPolicyRequest;
import software.amazon.awssdk.services.autoscaling.model.StepAdjustment;
import software.amazon.awssdk.services.autoscaling.model.TargetTrackingConfiguration;

public class PutScalingPolicyRequestMarshaller
implements Marshaller<Request<PutScalingPolicyRequest>, PutScalingPolicyRequest> {
    public Request<PutScalingPolicyRequest> marshall(PutScalingPolicyRequest putScalingPolicyRequest) {
        TargetTrackingConfiguration targetTrackingConfiguration;
        if (putScalingPolicyRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putScalingPolicyRequest, "AutoScalingClient");
        request.addParameter("Action", "PutScalingPolicy");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (putScalingPolicyRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)putScalingPolicyRequest.autoScalingGroupName()));
        }
        if (putScalingPolicyRequest.policyName() != null) {
            request.addParameter("PolicyName", StringConversion.fromString((String)putScalingPolicyRequest.policyName()));
        }
        if (putScalingPolicyRequest.policyType() != null) {
            request.addParameter("PolicyType", StringConversion.fromString((String)putScalingPolicyRequest.policyType()));
        }
        if (putScalingPolicyRequest.adjustmentType() != null) {
            request.addParameter("AdjustmentType", StringConversion.fromString((String)putScalingPolicyRequest.adjustmentType()));
        }
        if (putScalingPolicyRequest.minAdjustmentStep() != null) {
            request.addParameter("MinAdjustmentStep", StringConversion.fromInteger((Integer)putScalingPolicyRequest.minAdjustmentStep()));
        }
        if (putScalingPolicyRequest.minAdjustmentMagnitude() != null) {
            request.addParameter("MinAdjustmentMagnitude", StringConversion.fromInteger((Integer)putScalingPolicyRequest.minAdjustmentMagnitude()));
        }
        if (putScalingPolicyRequest.scalingAdjustment() != null) {
            request.addParameter("ScalingAdjustment", StringConversion.fromInteger((Integer)putScalingPolicyRequest.scalingAdjustment()));
        }
        if (putScalingPolicyRequest.cooldown() != null) {
            request.addParameter("Cooldown", StringConversion.fromInteger((Integer)putScalingPolicyRequest.cooldown()));
        }
        if (putScalingPolicyRequest.metricAggregationType() != null) {
            request.addParameter("MetricAggregationType", StringConversion.fromString((String)putScalingPolicyRequest.metricAggregationType()));
        }
        if (putScalingPolicyRequest.stepAdjustments().isEmpty() && !(putScalingPolicyRequest.stepAdjustments() instanceof SdkAutoConstructList)) {
            request.addParameter("StepAdjustments", "");
        } else if (!putScalingPolicyRequest.stepAdjustments().isEmpty() && !(putScalingPolicyRequest.stepAdjustments() instanceof SdkAutoConstructList)) {
            List<StepAdjustment> stepAdjustmentsList = putScalingPolicyRequest.stepAdjustments();
            int stepAdjustmentsListIndex = 1;
            for (StepAdjustment stepAdjustmentsListValue : stepAdjustmentsList) {
                if (stepAdjustmentsListValue.metricIntervalLowerBound() != null) {
                    request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalLowerBound", StringConversion.fromDouble((Double)stepAdjustmentsListValue.metricIntervalLowerBound()));
                }
                if (stepAdjustmentsListValue.metricIntervalUpperBound() != null) {
                    request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".MetricIntervalUpperBound", StringConversion.fromDouble((Double)stepAdjustmentsListValue.metricIntervalUpperBound()));
                }
                if (stepAdjustmentsListValue.scalingAdjustment() != null) {
                    request.addParameter("StepAdjustments.member." + stepAdjustmentsListIndex + ".ScalingAdjustment", StringConversion.fromInteger((Integer)stepAdjustmentsListValue.scalingAdjustment()));
                }
                ++stepAdjustmentsListIndex;
            }
        }
        if (putScalingPolicyRequest.estimatedInstanceWarmup() != null) {
            request.addParameter("EstimatedInstanceWarmup", StringConversion.fromInteger((Integer)putScalingPolicyRequest.estimatedInstanceWarmup()));
        }
        if ((targetTrackingConfiguration = putScalingPolicyRequest.targetTrackingConfiguration()) != null) {
            CustomizedMetricSpecification customizedMetricSpecification;
            PredefinedMetricSpecification predefinedMetricSpecification = targetTrackingConfiguration.predefinedMetricSpecification();
            if (predefinedMetricSpecification != null) {
                if (predefinedMetricSpecification.predefinedMetricTypeAsString() != null) {
                    request.addParameter("TargetTrackingConfiguration.PredefinedMetricSpecification.PredefinedMetricType", StringConversion.fromString((String)predefinedMetricSpecification.predefinedMetricTypeAsString()));
                }
                if (predefinedMetricSpecification.resourceLabel() != null) {
                    request.addParameter("TargetTrackingConfiguration.PredefinedMetricSpecification.ResourceLabel", StringConversion.fromString((String)predefinedMetricSpecification.resourceLabel()));
                }
            }
            if ((customizedMetricSpecification = targetTrackingConfiguration.customizedMetricSpecification()) != null) {
                if (customizedMetricSpecification.metricName() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.MetricName", StringConversion.fromString((String)customizedMetricSpecification.metricName()));
                }
                if (customizedMetricSpecification.namespace() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Namespace", StringConversion.fromString((String)customizedMetricSpecification.namespace()));
                }
                if (customizedMetricSpecification.dimensions().isEmpty() && !(customizedMetricSpecification.dimensions() instanceof SdkAutoConstructList)) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions", "");
                } else if (!customizedMetricSpecification.dimensions().isEmpty() && !(customizedMetricSpecification.dimensions() instanceof SdkAutoConstructList)) {
                    List<MetricDimension> dimensionsList = customizedMetricSpecification.dimensions();
                    int dimensionsListIndex = 1;
                    for (MetricDimension dimensionsListValue : dimensionsList) {
                        if (dimensionsListValue.name() != null) {
                            request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions.member." + dimensionsListIndex + ".Name", StringConversion.fromString((String)dimensionsListValue.name()));
                        }
                        if (dimensionsListValue.value() != null) {
                            request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Dimensions.member." + dimensionsListIndex + ".Value", StringConversion.fromString((String)dimensionsListValue.value()));
                        }
                        ++dimensionsListIndex;
                    }
                }
                if (customizedMetricSpecification.statisticAsString() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Statistic", StringConversion.fromString((String)customizedMetricSpecification.statisticAsString()));
                }
                if (customizedMetricSpecification.unit() != null) {
                    request.addParameter("TargetTrackingConfiguration.CustomizedMetricSpecification.Unit", StringConversion.fromString((String)customizedMetricSpecification.unit()));
                }
            }
            if (targetTrackingConfiguration.targetValue() != null) {
                request.addParameter("TargetTrackingConfiguration.TargetValue", StringConversion.fromDouble((Double)targetTrackingConfiguration.targetValue()));
            }
            if (targetTrackingConfiguration.disableScaleIn() != null) {
                request.addParameter("TargetTrackingConfiguration.DisableScaleIn", StringConversion.fromBoolean((Boolean)targetTrackingConfiguration.disableScaleIn()));
            }
        }
        return request;
    }
}

