/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.SetInstanceProtectionRequest;

public class SetInstanceProtectionRequestMarshaller
implements Marshaller<Request<SetInstanceProtectionRequest>, SetInstanceProtectionRequest> {
    public Request<SetInstanceProtectionRequest> marshall(SetInstanceProtectionRequest setInstanceProtectionRequest) {
        if (setInstanceProtectionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)setInstanceProtectionRequest, "AutoScalingClient");
        request.addParameter("Action", "SetInstanceProtection");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (setInstanceProtectionRequest.instanceIds().isEmpty() && !(setInstanceProtectionRequest.instanceIds() instanceof SdkAutoConstructList)) {
            request.addParameter("InstanceIds", "");
        } else if (!setInstanceProtectionRequest.instanceIds().isEmpty() && !(setInstanceProtectionRequest.instanceIds() instanceof SdkAutoConstructList)) {
            List<String> instanceIdsList = setInstanceProtectionRequest.instanceIds();
            int instanceIdsListIndex = 1;
            for (String instanceIdsListValue : instanceIdsList) {
                if (instanceIdsListValue != null) {
                    request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringConversion.fromString((String)instanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (setInstanceProtectionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)setInstanceProtectionRequest.autoScalingGroupName()));
        }
        if (setInstanceProtectionRequest.protectedFromScaleIn() != null) {
            request.addParameter("ProtectedFromScaleIn", StringConversion.fromBoolean((Boolean)setInstanceProtectionRequest.protectedFromScaleIn()));
        }
        return request;
    }
}

