/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.autoscaling.model.SuspendProcessesRequest;

public class SuspendProcessesRequestMarshaller
implements Marshaller<Request<SuspendProcessesRequest>, SuspendProcessesRequest> {
    public Request<SuspendProcessesRequest> marshall(SuspendProcessesRequest suspendProcessesRequest) {
        if (suspendProcessesRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)suspendProcessesRequest, "AutoScalingClient");
        request.addParameter("Action", "SuspendProcesses");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (suspendProcessesRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringConversion.fromString((String)suspendProcessesRequest.autoScalingGroupName()));
        }
        if (suspendProcessesRequest.scalingProcesses().isEmpty() && !(suspendProcessesRequest.scalingProcesses() instanceof SdkAutoConstructList)) {
            request.addParameter("ScalingProcesses", "");
        } else if (!suspendProcessesRequest.scalingProcesses().isEmpty() && !(suspendProcessesRequest.scalingProcesses() instanceof SdkAutoConstructList)) {
            List<String> scalingProcessesList = suspendProcessesRequest.scalingProcesses();
            int scalingProcessesListIndex = 1;
            for (String scalingProcessesListValue : scalingProcessesList) {
                if (scalingProcessesListValue != null) {
                    request.addParameter("ScalingProcesses.member." + scalingProcessesListIndex, StringConversion.fromString((String)scalingProcessesListValue));
                }
                ++scalingProcessesListIndex;
            }
        }
        return request;
    }
}

