/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAutoScalingInstancesRequest extends AutoScalingRequest implements
        ToCopyableBuilder<DescribeAutoScalingInstancesRequest.Builder, DescribeAutoScalingInstancesRequest> {
    private final List<String> instanceIds;

    private final Integer maxRecords;

    private final String nextToken;

    private DescribeAutoScalingInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.instanceIds = builder.instanceIds;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The IDs of the instances. You can specify up to <code>MaxRecords</code> IDs. If you omit this parameter, all Auto
     * Scaling instances are described. If you specify an ID that does not exist, it is ignored with no error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the instances. You can specify up to <code>MaxRecords</code> IDs. If you omit this parameter,
     *         all Auto Scaling instances are described. If you specify an ID that does not exist, it is ignored with no
     *         error.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * The maximum number of items to return with this call. The default value is 50 and the maximum value is 50.
     * </p>
     * 
     * @return The maximum number of items to return with this call. The default value is 50 and the maximum value is
     *         50.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceIds());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAutoScalingInstancesRequest)) {
            return false;
        }
        DescribeAutoScalingInstancesRequest other = (DescribeAutoScalingInstancesRequest) obj;
        return Objects.equals(instanceIds(), other.instanceIds()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeAutoScalingInstancesRequest").add("InstanceIds", instanceIds())
                .add("MaxRecords", maxRecords()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingRequest.Builder, CopyableBuilder<Builder, DescribeAutoScalingInstancesRequest> {
        /**
         * <p>
         * The IDs of the instances. You can specify up to <code>MaxRecords</code> IDs. If you omit this parameter, all
         * Auto Scaling instances are described. If you specify an ID that does not exist, it is ignored with no error.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the instances. You can specify up to <code>MaxRecords</code> IDs. If you omit this
         *        parameter, all Auto Scaling instances are described. If you specify an ID that does not exist, it is
         *        ignored with no error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The IDs of the instances. You can specify up to <code>MaxRecords</code> IDs. If you omit this parameter, all
         * Auto Scaling instances are described. If you specify an ID that does not exist, it is ignored with no error.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the instances. You can specify up to <code>MaxRecords</code> IDs. If you omit this
         *        parameter, all Auto Scaling instances are described. If you specify an ID that does not exist, it is
         *        ignored with no error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The maximum number of items to return with this call. The default value is 50 and the maximum value is 50.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of items to return with this call. The default value is 50 and the maximum value is
         *        50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AutoScalingRequest.BuilderImpl implements Builder {
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAutoScalingInstancesRequest model) {
            super(model);
            instanceIds(model.instanceIds);
            maxRecords(model.maxRecords);
            nextToken(model.nextToken);
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = InstanceIdsCopier.copy(instanceIds);
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAutoScalingInstancesRequest build() {
            return new DescribeAutoScalingInstancesRequest(this);
        }
    }
}
