/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeNotificationConfigurationsResponse extends AutoScalingResponse implements
        ToCopyableBuilder<DescribeNotificationConfigurationsResponse.Builder, DescribeNotificationConfigurationsResponse> {
    private final List<NotificationConfiguration> notificationConfigurations;

    private final String nextToken;

    private DescribeNotificationConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.notificationConfigurations = builder.notificationConfigurations;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The notification configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The notification configurations.
     */
    public List<NotificationConfiguration> notificationConfigurations() {
        return notificationConfigurations;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(notificationConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNotificationConfigurationsResponse)) {
            return false;
        }
        DescribeNotificationConfigurationsResponse other = (DescribeNotificationConfigurationsResponse) obj;
        return Objects.equals(notificationConfigurations(), other.notificationConfigurations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeNotificationConfigurationsResponse")
                .add("NotificationConfigurations", notificationConfigurations()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NotificationConfigurations":
            return Optional.ofNullable(clazz.cast(notificationConfigurations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingResponse.Builder,
            CopyableBuilder<Builder, DescribeNotificationConfigurationsResponse> {
        /**
         * <p>
         * The notification configurations.
         * </p>
         * 
         * @param notificationConfigurations
         *        The notification configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurations(Collection<NotificationConfiguration> notificationConfigurations);

        /**
         * <p>
         * The notification configurations.
         * </p>
         * 
         * @param notificationConfigurations
         *        The notification configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationConfigurations(NotificationConfiguration... notificationConfigurations);

        /**
         * <p>
         * The notification configurations.
         * </p>
         * This is a convenience that creates an instance of the {@link List<NotificationConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<NotificationConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NotificationConfiguration>.Builder#build()} is called
         * immediately and its result is passed to {@link #notificationConfigurations(List<NotificationConfiguration>)}.
         * 
         * @param notificationConfigurations
         *        a consumer that will call methods on {@link List<NotificationConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #notificationConfigurations(List<NotificationConfiguration>)
         */
        Builder notificationConfigurations(Consumer<NotificationConfiguration.Builder>... notificationConfigurations);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private List<NotificationConfiguration> notificationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeNotificationConfigurationsResponse model) {
            super(model);
            notificationConfigurations(model.notificationConfigurations);
            nextToken(model.nextToken);
        }

        public final Collection<NotificationConfiguration.Builder> getNotificationConfigurations() {
            return notificationConfigurations != null ? notificationConfigurations.stream()
                    .map(NotificationConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder notificationConfigurations(Collection<NotificationConfiguration> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copy(notificationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationConfigurations(NotificationConfiguration... notificationConfigurations) {
            notificationConfigurations(Arrays.asList(notificationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notificationConfigurations(Consumer<NotificationConfiguration.Builder>... notificationConfigurations) {
            notificationConfigurations(Stream.of(notificationConfigurations)
                    .map(c -> NotificationConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setNotificationConfigurations(
                Collection<NotificationConfiguration.BuilderImpl> notificationConfigurations) {
            this.notificationConfigurations = NotificationConfigurationsCopier.copyFromBuilder(notificationConfigurations);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeNotificationConfigurationsResponse build() {
            return new DescribeNotificationConfigurationsResponse(this);
        }
    }
}
