/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an enabled metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnabledMetric implements ToCopyableBuilder<EnabledMetric.Builder, EnabledMetric> {
    private final String metric;

    private final String granularity;

    private EnabledMetric(BuilderImpl builder) {
        this.metric = builder.metric;
        this.granularity = builder.granularity;
    }

    /**
     * <p>
     * One of the following metrics:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>GroupMinSize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupMaxSize</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupDesiredCapacity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupInServiceInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupPendingInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupStandbyInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupTerminatingInstances</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GroupTotalInstances</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return One of the following metrics:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>GroupMinSize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupMaxSize</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupDesiredCapacity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupInServiceInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupPendingInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupStandbyInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupTerminatingInstances</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GroupTotalInstances</code>
     *         </p>
     *         </li>
     */
    public String metric() {
        return metric;
    }

    /**
     * <p>
     * The granularity of the metric. The only valid value is <code>1Minute</code>.
     * </p>
     * 
     * @return The granularity of the metric. The only valid value is <code>1Minute</code>.
     */
    public String granularity() {
        return granularity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metric());
        hashCode = 31 * hashCode + Objects.hashCode(granularity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnabledMetric)) {
            return false;
        }
        EnabledMetric other = (EnabledMetric) obj;
        return Objects.equals(metric(), other.metric()) && Objects.equals(granularity(), other.granularity());
    }

    @Override
    public String toString() {
        return ToString.builder("EnabledMetric").add("Metric", metric()).add("Granularity", granularity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metric":
            return Optional.ofNullable(clazz.cast(metric()));
        case "Granularity":
            return Optional.ofNullable(clazz.cast(granularity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, EnabledMetric> {
        /**
         * <p>
         * One of the following metrics:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>GroupMinSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupMaxSize</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupDesiredCapacity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupInServiceInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupPendingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupStandbyInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTerminatingInstances</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GroupTotalInstances</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param metric
         *        One of the following metrics:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>GroupMinSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupMaxSize</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupDesiredCapacity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupInServiceInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupPendingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupStandbyInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTerminatingInstances</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GroupTotalInstances</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metric(String metric);

        /**
         * <p>
         * The granularity of the metric. The only valid value is <code>1Minute</code>.
         * </p>
         * 
         * @param granularity
         *        The granularity of the metric. The only valid value is <code>1Minute</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder granularity(String granularity);
    }

    static final class BuilderImpl implements Builder {
        private String metric;

        private String granularity;

        private BuilderImpl() {
        }

        private BuilderImpl(EnabledMetric model) {
            metric(model.metric);
            granularity(model.granularity);
        }

        public final String getMetric() {
            return metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        public final String getGranularity() {
            return granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public EnabledMetric build() {
            return new EnabledMetric(this);
        }
    }
}
