/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a scheduled action that could not be created, updated, or deleted.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FailedScheduledUpdateGroupActionRequest implements
        ToCopyableBuilder<FailedScheduledUpdateGroupActionRequest.Builder, FailedScheduledUpdateGroupActionRequest> {
    private final String scheduledActionName;

    private final String errorCode;

    private final String errorMessage;

    private FailedScheduledUpdateGroupActionRequest(BuilderImpl builder) {
        this.scheduledActionName = builder.scheduledActionName;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
    }

    /**
     * <p>
     * The name of the scheduled action.
     * </p>
     * 
     * @return The name of the scheduled action.
     */
    public String scheduledActionName() {
        return scheduledActionName;
    }

    /**
     * <p>
     * The error code.
     * </p>
     * 
     * @return The error code.
     */
    public String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The error message accompanying the error code.
     * </p>
     * 
     * @return The error message accompanying the error code.
     */
    public String errorMessage() {
        return errorMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FailedScheduledUpdateGroupActionRequest)) {
            return false;
        }
        FailedScheduledUpdateGroupActionRequest other = (FailedScheduledUpdateGroupActionRequest) obj;
        return Objects.equals(scheduledActionName(), other.scheduledActionName())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage());
    }

    @Override
    public String toString() {
        return ToString.builder("FailedScheduledUpdateGroupActionRequest").add("ScheduledActionName", scheduledActionName())
                .add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledActionName":
            return Optional.ofNullable(clazz.cast(scheduledActionName()));
        case "ErrorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "ErrorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, FailedScheduledUpdateGroupActionRequest> {
        /**
         * <p>
         * The name of the scheduled action.
         * </p>
         * 
         * @param scheduledActionName
         *        The name of the scheduled action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionName(String scheduledActionName);

        /**
         * <p>
         * The error code.
         * </p>
         * 
         * @param errorCode
         *        The error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error message accompanying the error code.
         * </p>
         * 
         * @param errorMessage
         *        The error message accompanying the error code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);
    }

    static final class BuilderImpl implements Builder {
        private String scheduledActionName;

        private String errorCode;

        private String errorMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(FailedScheduledUpdateGroupActionRequest model) {
            scheduledActionName(model.scheduledActionName);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
        }

        public final String getScheduledActionName() {
            return scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public FailedScheduledUpdateGroupActionRequest build() {
            return new FailedScheduledUpdateGroupActionRequest(this);
        }
    }
}
