/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements ToCopyableBuilder<Filter.Builder, Filter> {
    private final String name;

    private final List<String> values;

    private Filter(BuilderImpl builder) {
        this.name = builder.name;
        this.values = builder.values;
    }

    /**
     * <p>
     * The name of the filter. The valid values are: <code>"auto-scaling-group"</code>, <code>"key"</code>,
     * <code>"value"</code>, and <code>"propagate-at-launch"</code>.
     * </p>
     * 
     * @return The name of the filter. The valid values are: <code>"auto-scaling-group"</code>, <code>"key"</code>,
     *         <code>"value"</code>, and <code>"propagate-at-launch"</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The value of the filter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The value of the filter.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(values(), other.values());
    }

    @Override
    public String toString() {
        return ToString.builder("Filter").add("Name", name()).add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * The name of the filter. The valid values are: <code>"auto-scaling-group"</code>, <code>"key"</code>,
         * <code>"value"</code>, and <code>"propagate-at-launch"</code>.
         * </p>
         * 
         * @param name
         *        The name of the filter. The valid values are: <code>"auto-scaling-group"</code>, <code>"key"</code>,
         *        <code>"value"</code>, and <code>"propagate-at-launch"</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The value of the filter.
         * </p>
         * 
         * @param values
         *        The value of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The value of the filter.
         * </p>
         * 
         * @param values
         *        The value of the filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            name(model.name);
            values(model.values);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }
    }
}
