/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a launch template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchTemplateSpecification implements
        ToCopyableBuilder<LaunchTemplateSpecification.Builder, LaunchTemplateSpecification> {
    private final String launchTemplateId;

    private final String launchTemplateName;

    private final String version;

    private LaunchTemplateSpecification(BuilderImpl builder) {
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.version = builder.version;
    }

    /**
     * <p>
     * The ID of the launch template. You must specify either a template ID or a template name.
     * </p>
     * 
     * @return The ID of the launch template. You must specify either a template ID or a template name.
     */
    public String launchTemplateId() {
        return launchTemplateId;
    }

    /**
     * <p>
     * The name of the launch template. You must specify either a template name or a template ID.
     * </p>
     * 
     * @return The name of the launch template. You must specify either a template name or a template ID.
     */
    public String launchTemplateName() {
        return launchTemplateName;
    }

    /**
     * <p>
     * The version number, <code>$Latest</code>, or <code>$Default</code>. If the value is <code>$Latest</code>, Amazon
     * EC2 Auto Scaling selects the latest version of the launch template when launching instances. If the value is
     * <code>$Default</code>, Amazon EC2 Auto Scaling selects the default version of the launch template when launching
     * instances. The default value is <code>$Default</code>.
     * </p>
     * 
     * @return The version number, <code>$Latest</code>, or <code>$Default</code>. If the value is <code>$Latest</code>,
     *         Amazon EC2 Auto Scaling selects the latest version of the launch template when launching instances. If
     *         the value is <code>$Default</code>, Amazon EC2 Auto Scaling selects the default version of the launch
     *         template when launching instances. The default value is <code>$Default</code>.
     */
    public String version() {
        return version;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateSpecification)) {
            return false;
        }
        LaunchTemplateSpecification other = (LaunchTemplateSpecification) obj;
        return Objects.equals(launchTemplateId(), other.launchTemplateId())
                && Objects.equals(launchTemplateName(), other.launchTemplateName()) && Objects.equals(version(), other.version());
    }

    @Override
    public String toString() {
        return ToString.builder("LaunchTemplateSpecification").add("LaunchTemplateId", launchTemplateId())
                .add("LaunchTemplateName", launchTemplateName()).add("Version", version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LaunchTemplateId":
            return Optional.ofNullable(clazz.cast(launchTemplateId()));
        case "LaunchTemplateName":
            return Optional.ofNullable(clazz.cast(launchTemplateName()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, LaunchTemplateSpecification> {
        /**
         * <p>
         * The ID of the launch template. You must specify either a template ID or a template name.
         * </p>
         * 
         * @param launchTemplateId
         *        The ID of the launch template. You must specify either a template ID or a template name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateId(String launchTemplateId);

        /**
         * <p>
         * The name of the launch template. You must specify either a template name or a template ID.
         * </p>
         * 
         * @param launchTemplateName
         *        The name of the launch template. You must specify either a template name or a template ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTemplateName(String launchTemplateName);

        /**
         * <p>
         * The version number, <code>$Latest</code>, or <code>$Default</code>. If the value is <code>$Latest</code>,
         * Amazon EC2 Auto Scaling selects the latest version of the launch template when launching instances. If the
         * value is <code>$Default</code>, Amazon EC2 Auto Scaling selects the default version of the launch template
         * when launching instances. The default value is <code>$Default</code>.
         * </p>
         * 
         * @param version
         *        The version number, <code>$Latest</code>, or <code>$Default</code>. If the value is
         *        <code>$Latest</code>, Amazon EC2 Auto Scaling selects the latest version of the launch template when
         *        launching instances. If the value is <code>$Default</code>, Amazon EC2 Auto Scaling selects the
         *        default version of the launch template when launching instances. The default value is
         *        <code>$Default</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);
    }

    static final class BuilderImpl implements Builder {
        private String launchTemplateId;

        private String launchTemplateName;

        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateSpecification model) {
            launchTemplateId(model.launchTemplateId);
            launchTemplateName(model.launchTemplateName);
            version(model.version);
        }

        public final String getLaunchTemplateId() {
            return launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        public final String getLaunchTemplateName() {
            return launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        public final String getVersion() {
            return version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public LaunchTemplateSpecification build() {
            return new LaunchTemplateSpecification(this);
        }
    }
}
