/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum ScalingActivityStatusCode {
    PENDING_SPOT_BID_PLACEMENT("PendingSpotBidPlacement"),

    WAITING_FOR_SPOT_INSTANCE_REQUEST_ID("WaitingForSpotInstanceRequestId"),

    WAITING_FOR_SPOT_INSTANCE_ID("WaitingForSpotInstanceId"),

    WAITING_FOR_INSTANCE_ID("WaitingForInstanceId"),

    PRE_IN_SERVICE("PreInService"),

    IN_PROGRESS("InProgress"),

    WAITING_FOR_ELB_CONNECTION_DRAINING("WaitingForELBConnectionDraining"),

    MID_LIFECYCLE_ACTION("MidLifecycleAction"),

    WAITING_FOR_INSTANCE_WARMUP("WaitingForInstanceWarmup"),

    SUCCESSFUL("Successful"),

    FAILED("Failed"),

    CANCELLED("Cancelled"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ScalingActivityStatusCode(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ScalingActivityStatusCode corresponding to the value
     */
    public static ScalingActivityStatusCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ScalingActivityStatusCode.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ScalingActivityStatusCode}s
     */
    public static Set<ScalingActivityStatusCode> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
