/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminateInstanceInAutoScalingGroupResponse extends AutoScalingResponse implements
        ToCopyableBuilder<TerminateInstanceInAutoScalingGroupResponse.Builder, TerminateInstanceInAutoScalingGroupResponse> {
    private final Activity activity;

    private TerminateInstanceInAutoScalingGroupResponse(BuilderImpl builder) {
        super(builder);
        this.activity = builder.activity;
    }

    /**
     * <p>
     * A scaling activity.
     * </p>
     * 
     * @return A scaling activity.
     */
    public Activity activity() {
        return activity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminateInstanceInAutoScalingGroupResponse)) {
            return false;
        }
        TerminateInstanceInAutoScalingGroupResponse other = (TerminateInstanceInAutoScalingGroupResponse) obj;
        return Objects.equals(activity(), other.activity());
    }

    @Override
    public String toString() {
        return ToString.builder("TerminateInstanceInAutoScalingGroupResponse").add("Activity", activity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Activity":
            return Optional.ofNullable(clazz.cast(activity()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends AutoScalingResponse.Builder,
            CopyableBuilder<Builder, TerminateInstanceInAutoScalingGroupResponse> {
        /**
         * <p>
         * A scaling activity.
         * </p>
         * 
         * @param activity
         *        A scaling activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activity(Activity activity);

        /**
         * <p>
         * A scaling activity.
         * </p>
         * This is a convenience that creates an instance of the {@link Activity.Builder} avoiding the need to create
         * one manually via {@link Activity#builder()}.
         *
         * When the {@link Consumer} completes, {@link Activity.Builder#build()} is called immediately and its result is
         * passed to {@link #activity(Activity)}.
         * 
         * @param activity
         *        a consumer that will call methods on {@link Activity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activity(Activity)
         */
        default Builder activity(Consumer<Activity.Builder> activity) {
            return activity(Activity.builder().applyMutation(activity).build());
        }
    }

    static final class BuilderImpl extends AutoScalingResponse.BuilderImpl implements Builder {
        private Activity activity;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminateInstanceInAutoScalingGroupResponse model) {
            super(model);
            activity(model.activity);
        }

        public final Activity.Builder getActivity() {
            return activity != null ? activity.toBuilder() : null;
        }

        @Override
        public final Builder activity(Activity activity) {
            this.activity = activity;
            return this;
        }

        public final void setActivity(Activity.BuilderImpl activity) {
            this.activity = activity != null ? activity.build() : null;
        }

        @Override
        public TerminateInstanceInAutoScalingGroupResponse build() {
            return new TerminateInstanceInAutoScalingGroupResponse(this);
        }
    }
}
