/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.autoscaling.transform;

import java.util.List;

import javax.annotation.Generated;

import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.services.autoscaling.model.*;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;

/**
 * BatchDeleteScheduledActionRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class BatchDeleteScheduledActionRequestMarshaller implements
        Marshaller<Request<BatchDeleteScheduledActionRequest>, BatchDeleteScheduledActionRequest> {

    public Request<BatchDeleteScheduledActionRequest> marshall(BatchDeleteScheduledActionRequest batchDeleteScheduledActionRequest) {

        if (batchDeleteScheduledActionRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }

        Request<BatchDeleteScheduledActionRequest> request = new DefaultRequest<BatchDeleteScheduledActionRequest>(
                batchDeleteScheduledActionRequest, "AutoScalingClient");
        request.addParameter("Action", "BatchDeleteScheduledAction");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (batchDeleteScheduledActionRequest.autoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName",
                    StringConversion.fromString(batchDeleteScheduledActionRequest.autoScalingGroupName()));
        }

        if (batchDeleteScheduledActionRequest.scheduledActionNames().isEmpty()
                && !(batchDeleteScheduledActionRequest.scheduledActionNames() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            request.addParameter("ScheduledActionNames", "");
        } else if (!batchDeleteScheduledActionRequest.scheduledActionNames().isEmpty()
                && !(batchDeleteScheduledActionRequest.scheduledActionNames() instanceof software.amazon.awssdk.core.util.SdkAutoConstructList)) {
            java.util.List<String> scheduledActionNamesList = batchDeleteScheduledActionRequest.scheduledActionNames();
            int scheduledActionNamesListIndex = 1;

            for (String scheduledActionNamesListValue : scheduledActionNamesList) {
                if (scheduledActionNamesListValue != null) {
                    request.addParameter("ScheduledActionNames.member." + scheduledActionNamesListIndex,
                            StringConversion.fromString(scheduledActionNamesListValue));
                }
                scheduledActionNamesListIndex++;
            }
        }

        return request;
    }

}
